; C0.ASM--
; Copyright (c) 2009-2010 Hjort Nidudsson
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; Change history:
; 03/17/2010 - restored Ctrl-C handler on exit (o-o)
; 02/28/2010 - added Ctrl-C handler (int 23)
; 02/28/2010 - added extern System Error handler (int 24)

ifndef __s__
 ifndef __c__
  ifndef __m__
   ifndef __l__
     %out you must supply a model symbol.
     .err
   endif
  endif
 endif
endif

	.186

include	build.inc
include	version.inc

FCODE	EQU	8000h
FDATA	EQU	4000h

ifdef	__s__
	MMODEL	EQU	1
endif

ifdef	__c__
	LDATA	EQU	1
	MMODEL	EQU	FDATA+3
endif

ifdef	__m__
	LPROG 	EQU	1
	MMODEL	EQU	FCODE+2
endif

ifdef	__l__
	LPROG 	EQU	1
	LDATA	EQU	1
	MMODEL	EQU	FCODE+FDATA+4
endif

ifdef 	LPROG
	DIST  	EQU    	<FAR>
else
	DIST  	EQU    	<NEAR>
endif

ifdef 	LDATA
	DPTRZ	EQU	4
else
	DPTRZ 	EQU	2
endif

IFFD	MACRO Instruction, des, src
	IFDEF LDATA
	 IFNB <src>
	      Instruction des, src
	 ELSE
	      Instruction des
	 ENDIF
	ENDIF
	ENDM

IFND 	MACRO Instruction, des, src
	IFNDEF LDATA
	 IFNB <src>
	      Instruction des, src
	 ELSE
	      Instruction des
	 ENDIF
	ENDIF
	ENDM

_TEXT	SEGMENT	BYTE PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT	WORD PUBLIC 'DATA'
_DATA	ENDS

if USE_C0CONST
 CONST	SEGMENT	WORD PUBLIC 'DATA'
 CONST	ENDS
 CONST2	SEGMENT	WORD PUBLIC 'DATA'
 CONST2	ENDS
endif

if USE_C0INIT
 _INIT_	SEGMENT	WORD PUBLIC 'INITDATA'
 _INIT_	ENDS
 _INITEND_ SEGMENT BYTE PUBLIC 'INITDATA'
 _INITEND_ ENDS
endif

if USE_C0EXIT
 _EXIT_	SEGMENT	WORD PUBLIC 'EXITDATA'
 _EXIT_	ENDS
 _EXITEND_ SEGMENT BYTE PUBLIC 'EXITDATA'
 _EXITEND_ ENDS
endif

if USE_C0BSS
 _BSS	SEGMENT WORD PUBLIC 'BSS'
 _BSS	ENDS
 _BSSEND SEGMENT BYTE PUBLIC 'BSSEND'
 _BSSEND ENDS
endif

_STACK	SEGMENT STACK 'STACK'
_STACK	ENDS

if USE_C0EXIT
 if USE_C0BSS
  if USE_C0INIT
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_INIT_,_INITEND_,_EXIT_,_EXITEND_,_BSS,_BSSEND
   else
    DGROUP GROUP _DATA,_INIT_,_INITEND_,_EXIT_,_EXITEND_,_BSS,_BSSEND
   endif
  else
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_EXIT_,_EXITEND_,_BSS,_BSSEND
   else
    DGROUP GROUP _DATA,_EXIT_,_EXITEND_,_BSS,_BSSEND
   endif
  endif
 else
  if USE_C0INIT
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_INIT_,_INITEND_,_EXIT_,_EXITEND_
   else
    DGROUP GROUP _DATA,_INIT_,_INITEND_,_EXIT_,_EXITEND_
   endif
  else
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_EXIT_,_EXITEND_
   else
    DGROUP GROUP _DATA,_EXIT_,_EXITEND_
   endif
  endif
 endif
else
 if USE_C0BSS
  if USE_C0INIT
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_INIT_,_INITEND_,_BSS,_BSSEND
   else
    DGROUP GROUP _DATA,_INIT_,_INITEND_,_BSS,_BSSEND
   endif
  else
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_BSS,_BSSEND
   else
    DGROUP GROUP _DATA,_BSS,_BSSEND
   endif
  endif
 else
  if USE_C0INIT
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2,_INIT_,_INITEND_
   else
    DGROUP GROUP _DATA,_INIT_,_INITEND_
   endif
  else
   if USE_C0CONST
    DGROUP GROUP _DATA,CONST,CONST2
   else
    DGROUP GROUP _DATA
   endif
  endif
 endif
endif
	ASSUME  CS:_TEXT, DS:DGROUP

	public	_cleanup
	public  _terminate
	public 	_restorezero
	public  _abort
	public	stderrmsg
	public	DGROUP@
if USE_C0ARGV
	public	_argc
	public	_argv
endif
	public	envseg
	public	envlen
	public	envsize
	public	_psp
	public	_osversion
	public	_osminor
	public	_osmajor
	public	errno
	public	doserrno
if USE_C0INT24
	public  sys_erdevice
	public  sys_ercode
	public  sys_erflag
	public  sys_erdrive
	public  sys_erproc
endif
ifndef LDATA
	public	__heapbase
	public	__brklvl
else
	public	_heaptop
	public	_heapbase
	public	_brklvl
endif

ifdef DEBUG
	extrn main:	DIST
else
	extrn main_:	DIST
endif
	extrn exit:	DIST
	extrn _ioinit:  DIST
	extrn _nfile:   WORD
IFND	extrn,__heaplen:WORD

_TEXT	SEGMENT

DGROUP@	LABEL	WORD
	DD	564A4A0Ah
	DB	10,'DOSZIP RTL v',DOSZIP_VSTR,', ',DOSZIP_DATE,10

START	PROC
	MOV	DX,SEG _DATA
	MOV	CS:[DGROUP@],DX
	MOV	AH,30h
	INT	21h
	MOV	BP,DS:[0002h]
	MOV	BX,DS:[002Ch]
	MOV	DS,DX
	MOV	_osversion,AX
	MOV	_psp,ES
	MOV	envseg,BX
	MOV	WORD PTR _heaptop+2,BP
if USE_C0INT23
	MOV	AX,3523h
	INT	21h
	MOV	WORD PTR Interrupt_23,BX
	MOV	WORD PTR Interrupt_23+2,ES
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	AX,2523h
	MOV	DX,OFFSET INT23HANDLER
	INT	21h
	POP	DS
endif
if USE_C0INT24
	MOV	AX,3524h
	INT	21h
	MOV	WORD PTR Interrupt_24,BX
	MOV	WORD PTR Interrupt_24+2,ES
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	AX,2524h
	MOV	DX,OFFSET INT24HANDLER
	INT	21h
	POP	DS
endif
	MOV	AX,envseg
	MOV	ES,AX
	XOR	DI,DI
	MOV	BX,DI
	MOV	CX,7FFFh
	CLD
START_00:
	MOV	AL,0
	REPNZ	SCASB
	JCXZ	START_07
	INC	BX
	CMP	ES:[DI],AL
	JNZ	START_00
	OR	CH,80h
	NEG	CX
	MOV	envlen,CX
	MOV	CX,DPTRZ/2
	SHL	BX,CL
	ADD	BX,DPTRZ*4
	AND	BX,NOT ((DPTRZ*4)-1)
	MOV	envsize,BX
ifdef LDATA
	MOV	DX,SS
else
	MOV	DX,DS
endif
	SUB	BP,DX
	MOV	DI,STACKLENGTH
ifndef LDATA
	ADD	DI,OFFSET DGROUP:edata@
	JB	START_07
	ADD	DI,__heaplen
	JB	START_07
endif
	MOV	CL,4
	SHR	DI,CL
	INC	DI
	CMP	BP,DI
ifdef LDATA
	JNB	START_08
else
	JB	START_07
	CMP	_stklen,0
	JE	START_01
	CMP	__heaplen,0
	JNE	START_08
START_01:
	MOV	DI,1000h
	CMP	BP,DI
	JA	START_08
	MOV	BP,DI
	JMP	START_08
endif
START_07:
	JMP	_abort
START_08:
	MOV	BX,DI
	ADD	BX,DX
	MOV	WORD PTR _heapbase+2,BX
	MOV	WORD PTR _brklvl+2,BX
	MOV	AX,_psp
	SUB	BX,AX
	MOV	ES,AX
	PUSH	DI
	MOV	AX,4A00h
	INT	21h
	POP	DI
	SHL	DI,CL
	MOV	SS,DX
	MOV	SP,DI
if USE_C0ARGV
	MOV	BP,_psp
	MOV	SI,0080h
	XOR	AX,AX
	CLD
	MOV	AL,ES:[SI]
	INC	SI
	INC	AX
	MOV	DX,SI
	XCHG	BX,AX
	MOV	SI,envlen
	INC	SI
	INC	SI
	MOV	ES,envseg
	MOV	DI,SI
	MOV	CX,7Fh
	XOR	AL,AL
	REPNZ	SCASB
	JCXZ	START_13
	XOR	CL,7Fh
	PUSH	AX
	MOV	AX,CX
	ADD	AX,BX
	INC	AX
	AND	AX,NOT 1
	MOV	DI,SP
	SUB	DI,AX
	JB	START_13
	MOV	SP,DI
	PUSH	ES
	POP	DS
	PUSH	SS
	POP	ES
	PUSH	CX
	DEC	CX
	REP	MOVSB
	XOR	AL,AL
	STOSB
	MOV	DS,BP
	XCHG	DX,SI
	XCHG	CX,BX
	MOV	AX,BX
	MOV	DX,AX
	INC	BX
START_09:
	CALL	START_14
	JA	START_11
START_10:
	JB	START_18
	CMP	AL,13
	JE	START_12
	CALL	START_14
	JA	START_10
START_11:
	CMP	AL,' '
	JE	START_12
	CMP	AL,13
	JE	START_12
	CMP	AL,9
	JNZ	START_09
START_12:
	XOR	AL,AL
	JMP	START_09
START_13:
	JMP	_abort
START_14:
	OR	AX,AX
	JZ	START_15
	INC	DX
	STOSB
	OR	AL,AL
	JNZ	START_15
	INC	BX
START_15:
	XCHG	AH,AL
	XOR	AL,AL
	STC
	JCXZ	START_17
	LODSB
	DEC	CX
	SUB	AL,'"'
	JZ	START_17
	ADD	AL,'"'
	CMP	AL,'\'
	JNZ	START_16
	CMP	BYTE PTR [SI],'"'
	JNZ	START_16
	LODSB
	DEC	CX
START_16:
	OR	SI,SI
START_17:
	RET
START_18:
	POP	CX
	ADD	CX,DX
	MOV	DS,CS:DGROUP@
	MOV	_argc,BX
	INC	BX
	ADD	BX,BX
 ifdef LDATA
	ADD	BX,BX
 endif
	MOV	SI,SP
	MOV	BP,SP
	SUB	BP,BX
	JB	START_13
	MOV	SP,BP
 ifdef LDATA
	MOV	WORD PTR _argv,BP
	MOV	WORD PTR _argv+2,SS
 else
	MOV	_argv,BP
 endif
START_19:
	JCXZ	START_21
	MOV	[BP],SI
 ifdef LDATA
	MOV	[BP+2],SS
 endif
	ADD	BP,DPTRZ
START_20:
	LODS	BYTE PTR SS:[SI]
	OR	AL,AL
	LOOPNZ	START_20
	JZ	START_19
START_21:
	XOR	AX,AX
	MOV	[BP],AX
	MOV	DS,CS:DGROUP@
ifdef 	LDATA
	MOV	[BP+2],AX
;	MOV	DX,SEG _stklen
;	MOV	ES,DX
;	MOV	ES:_stklen,DI
endif
endif ; USE_C0ARGV

if USE_C0BSS
	MOV	DX,CS:DGROUP@
	MOV	ES,DX
	MOV	DI,OFFSET DGROUP:bdata@
	MOV	CX,OFFSET DGROUP:edata@
	SUB	CX,DI
	CLD
	REP	STOSB
endif
	XOR	BP,BP
if USE_C0INIT
	MOV	AX,seg _INIT_
	MOV	ES,CS:DGROUP@
	MOV	SI,OFFSET DGROUP:InitStart
	MOV	DI,OFFSET DGROUP:InitEnd
	CALL	INITIALIZE
endif

if USE_C0ARGV
	MOV	AX,_argc
	MOV	BX,WORD PTR _argv
	MOV	CX,WORD PTR _argv+2
	PUSH	AX
	PUSH	CX
	PUSH	BX
endif
ifdef DEBUG
	CALL	main
else
	CALL	main_
endif
	PUSH	AX
	CALL	exit

_cleanup PROC DIST
ifdef __EXIT__
	MOV	ES,CS:DGROUP@
	PUSH	SI
	PUSH	DI
	MOV	SI,OFFSET DGROUP:ExitStart
	MOV	DI,OFFSET DGROUP:ExitEnd
	CALL	CLEANUP
	POP	DI
	POP	SI
endif
	RET
_cleanup ENDP

_terminate PROC DIST
	MOV	BP,SP
ifdef LPROG
	MOV	AX,[BP+4]
else
	MOV	AX,[BP+2]
endif
	MOV	AH,4Ch
	INT	21h
_terminate ENDP

START	ENDP

if USE_C0INT24

INT24HANDLER	PROC
		PUSH	DS
		MOV	DS,CS:[DGROUP@]
		MOV	sys_erflag,AH
		MOV	sys_erdrive,AL
		MOV	AX,DI
		MOV	AH,0
		MOV	sys_ercode,AX
		MOV	WORD PTR sys_erdevice,SI
		MOV	WORD PTR sys_erdevice+2,BP
		MOV	AL,3
		CMP	WORD PTR sys_erproc,0
		JE	INT24_00
		; PUSH ES BX CX DX
		CALL	sys_erproc
		; POP DX CX BX ES
INT24_00:	POP	DS
INT24HANDLER	ENDP

INT23HANDLER	PROC
		IRET
INT23HANDLER	ENDP

endif

PNEAR		EQU     0
PFAR		EQU     1
NOTUSED		EQU     0FFh

INITIALIZE	PROC
INIT_00:	MOV	AX,0100h
		MOV	DX,DI
		MOV	BX,SI
INIT_01:	CMP	BX,DI
		JE	INIT_03
		CMP	BYTE PTR ES:[BX],NOTUSED
		JE     	INIT_02
		MOV	CL,ES:[BX+1]
		XOR	CH,CH
		CMP	CX,AX
		JAE	INIT_02
		MOV	AX,CX
		MOV	DX,BX
INIT_02:	ADD	BX,6
		JMP	INIT_01
INIT_03:	CMP	DX,DI
		JE	INIT_05
		MOV	BX,DX
		CMP	BYTE PTR ES:[BX],PNEAR
		MOV	BYTE PTR ES:[BX],NOTUSED
		PUSH	ES
		JE	INIT_04
		CALL	DWORD PTR ES:[BX+2]
		POP	ES
		JMP	INIT_00
INIT_04:     	CALL	WORD PTR ES:[BX+2]
		POP	ES
		JMP	INIT_00
INIT_05:	RET
INITIALIZE	ENDP

if USE_C0EXIT

CLEANUP		PROC
EXIT_00:	MOV	AX,00FFh
		MOV	DX,DI
		MOV	BX,SI
EXIT_01:	CMP	BX,DI
		JE	EXIT_03
		CMP	ES:[BX],AL
		JE     	EXIT_02
		CMP	ES:[BX+1],AH
		JB     	EXIT_02
		MOV	AH,ES:[BX+1]
		MOV	DX,BX
EXIT_02:	ADD	BX,6
		JMP	EXIT_01
EXIT_03:	CMP	DX,DI
		JE	EXIT_05
		MOV	BX,DX
		CMP	BYTE PTR ES:[BX],PNEAR
		MOV	BYTE PTR ES:[BX],NOTUSED
		PUSH	ES
		JE	EXIT_04
		CALL	DWORD PTR ES:[BX+2]
		POP	ES
		JMP	EXIT_00
EXIT_04:     	CALL	WORD PTR ES:[BX+2]
		POP	ES
		JMP	EXIT_00
EXIT_05:	RET
CLEANUP		ENDP

endif

_restorezero PROC DIST
if USE_C0INT23
	PUSH	DS
	MOV	AX,2523h
	LDS	DX,Interrupt_23
	INT	21h
	POP	DS
endif
if USE_C0INT24
	PUSH	DS
	MOV	AX,2524h
	LDS	DX,Interrupt_24
	INT	21h
	POP	DS
endif
	RET
_restorezero ENDP

stderrmsg PROC
	MOV	AH,40h
	MOV	BX,2
	INT	21h
	RET
stderrmsg ENDP

_abort	PROC DIST
	MOV	CX,sizeabortmsg
	MOV	DX,OFFSET DGROUP:abortmsg
	CALL	stderrmsg
	MOV	AX,3
	PUSH	AX
	CALL	exit
_abort	ENDP

ifdef DEBUG

; __MMODEL is used to determine the memory model or the default
; pointer types at run time.

	public	__MMODEL

__MMODEL DW	MMODEL

endif

_TEXT	ENDS

_DATA	SEGMENT

ifdef DEBUG

; Magic symbol used by the debug info to locate the data segment
	public 	DATASEG@
DATASEG@ LABEL  BYTE

endif

NULL	LABEL	WORD
cp_null	DB	0,0,0,0

abortmsg DB	'Abnormal program termination', 13, 10
sizeabortmsg	= $ - abortmsg

if USE_C0ARGV
_argc		DW	0
 ifdef LDATA
  _argv		DD	0
 else
  _argv		DW	0
 endif
endif

envseg		DW 	0
envlen	  	DW 	0
envsize	  	DW 	0
_psp		DW 	0
_osversion	LABEL	WORD
_osmajor	DB	0
_osminor	DB	0
errno		DW	0
doserrno	DW	0

if USE_C0INT24
ifdef LPROG
 sys_erproc	DD 0
else
 sys_erproc	DW 0
endif
sys_erdevice    DD 0
sys_ercode	DW 0
sys_erflag	DB 0
sys_erdrive	DB 0
Interrupt_24	DD ?
endif

if USE_C0INT23
Interrupt_23	DD ?
endif

ifndef LDATA
__heapbase	DW DGROUP:edata@
__brklvl	DW DGROUP:edata@
else
_heaptop	DD 0
_heapbase	DD 0
_brklvl		DD 0
endif

_DATA	ENDS

if USE_C0INIT
_INIT_	SEGMENT	WORD PUBLIC 'INITDATA'
 InitStart LABEL BYTE
_INIT_	ENDS
_INITEND_ SEGMENT BYTE PUBLIC 'INITDATA'
 InitEnd LABEL BYTE
_INITEND_ ENDS
endif

if USE_C0EXIT
_EXIT_ 	SEGMENT	WORD PUBLIC 'EXITDATA'
 ExitStart LABEL BYTE
_EXIT_	ENDS
_EXITEND_ SEGMENT BYTE PUBLIC 'EXITDATA'
 ExitEnd  LABEL BYTE
_EXITEND_ ENDS
endif

if USE_C0BSS
_BSS	SEGMENT
 bdata@	LABEL BYTE
_BSS	ENDS
_BSSEND	SEGMENT
 edata@	LABEL BYTE
_BSSEND	ENDS
endif

_STACK	SEGMENT
	DB	124 dup(?)
	DD	564A4A0Ah
_STACK	ENDS

	END	START
