#ifndef __INC_WSUB
#define __INC_WSUB

#include <dir.h>
#include <fblock.h>

#define WMAXFBLOCK	0x3FFF

#define _W_PANELID	0x0001
#define _W_VISIBLE	0x0002
#define _W_MINISTATUS	0x0004
#define _W_CURPATH	0x0008
#define _W_LONGNAME	0x0010
#define _W_DETAIL	0x0020
#define _W_HIDDEN	0x0040
#define _W_LOCALE	0x0000
#define _W_FLOPPY	0x0080
#define _W_CDROOM	0x0100
#define _W_NETWORK	0x0180
#define _W_SORTNAME	0x0000
#define _W_SORTTYPE     0x0200
#define _W_SORTDATE     0x0400
#define _W_SORTSIZE	0x0600
#define _W_NOSORT	0x0800
#define _W_SORTSUB	0x1000
#define _W_DRVINFO	0x2000
#define _W_ARCHIVE	0xC000
#define _W_ARCHZIP	0x8000

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct {
	WORD	flag;
	char	mask[32];	/* read mask (*.*) */
	char	path[WMAXPATH];	/* current path	*/
	char	file[WMAXPATH];	/* archive file-name */
	char	arch[WMAXPATH];	/* path in archive */
      }	PATH;

typedef struct {
	int	count;  	/* number of blocks in buffer */
	int 	maxfb;		/* max fileblock in WSUB */
	WORD *	flag;
	char *	mask; 		/* read mask (*.*) */
	char *	path;		/* current path	*/
	char *	file;		/* archive file-name */
	char *	arch;		/* path in archive */
	FBLK **	fcb;		/* pointer to fileblocks */
      }	WSUB;

int 	_CType wsopen(WSUB *);
int 	_CType wsclose(WSUB *);
int 	_CType wsfree(WSUB *);
int 	_CType wsinit(WSUB *);
int 	_CType wslocal(WSUB *);
int 	_CType wsearch(WSUB *, char *);
int 	_CType wschdrv(WSUB *, int __drv);
int 	_CType wschdir(WSUB *, FBLK *);
int 	_CType wssetflag(WSUB *);
int 	_CType wscdroom(WSUB *);
void 	_CType wssort(WSUB *);
FBLK *	_CType wsfblk(WSUB *, int __index);
FBLK *	_CType wsffirst(WSUB *);
int 	_CType wsopenarch(WSUB *);
char *	_CType wssavepath(WSUB *);
int 	_CType wsread(WSUB *);
int 	_CType wsreadsub(WSUB *);
int 	_CType wsreadff(WSUB *, int __scan_attrib);
int 	_CType wsreadwf(WSUB *, int __scan_attrib);
int 	_CType wsmkdir(WSUB *, char *__directory);
int 	_CType wsmkdirlocal(char *__directory);
int 	_CType wzipread(WSUB *);

extern char *srcpath;
extern char *outpath;
extern char *srcfile;
extern char *outfile;
extern char __srcpath[WMAXPATH];
extern char __outpath[WMAXPATH];
extern char __srcfile[WMAXPATH];
extern char __outfile[WMAXPATH];
extern char cp_stdmask[];
extern char cp_warning[];
extern char cp_emaxfb[];

#ifdef __cplusplus
 }
#endif
#endif
