; XCELL.ASM--
; Copyright (c) 1996 Hjort Nidudsson
;

INCLUDE		clib.inc
INCLUDE		dzmain.inc
INCLUDE		string.inc
INCLUDE		arch.inc
INCLUDE		dialog.inc
INCLUDE		io.inc

GLOBAL PASCAL	pcell_set:	DIST
GLOBAL PASCAL	pcell_show:	DIST
GLOBAL PASCAL	pcell_update:	DIST
GLOBAL PASCAL	pcell_select:	DIST
GLOBAL PASCAL	pcell_setxy:	DIST
GLOBAL PASCAL	pcell_move:	DIST
GLOBAL PASCAL	ccell_edit:	DIST


GLOBAL PASCAL	notsup:		DIST
GLOBAL PASCAL	cmcopy:		DIST
GLOBAL PASCAL	cmmove:		DIST
GLOBAL PASCAL	dzipren:	DIST
GLOBAL PASCAL	xl_setcell:	DIST
GLOBAL PASCAL	invert_fb:	DIST
GLOBAL PASCAL	panel_putmini:	DIST
GLOBAL PASCAL	panel_xycmd:	DIST
GLOBAL PASCAL	cpanel_findfirst: DIST
GLOBAL PASCAL	panel_numselected: DIST
GLOBAL PASCAL	panel_update_fcb: DIST

cell_flag	= (_D_BACKG or _D_MYBUF)

_DATA		SEGMENT

cp_copyselected	DB	'[%04d file(s)]',0

_DATA		ENDS

XCELL_TEXT	SEGMENT USE16 BYTE PUBLIC 'CODE'
		ASSUME CS:XCELL_TEXT, DS:DGROUP

pcell_set	PROC	PASCAL	DIST
ARG		panel:	DWORD
		USES	si,di
		mov	si,WORD PTR panel
		mov	di,WORD PTR [si.pn_xl]
		mov	al,[di.xl_cols]
		mul	[di.xl_rows]
		mov	dx,[si.pn_fcb_count]
		sub	dx,[si.pn_fcb_index]
		cmp	ax,dx
		jb	SHORT @@
		mov	ax,dx
@@:		mov	[si.pn_cel_count],ax
		push	ds
		push	di
		push	[si.pn_cel_index]
		push	ax
		call	xl_setcell
		mov	[si.pn_cel_index],ax
		ret
pcell_set	ENDP

PCellOpen:	mov	bx,WORD PTR panel
		push	[bx.pn_xl]
		mov	al,at_background[B_DarkGray]
		or	al,at_foreground[F_Black]
		push	ax
		xor	eax,eax
		push	eax
		call	twopen
		ret

pcell_show	PROC	PASCAL	DIST
ARG		panel:	DWORD
		USES	si,di
		mov	si,WORD PTR panel
		mov	di,WORD PTR [si.pn_xl]
		xor	ax,ax
		test	[di.xl_flag],(_D_DOPEN or _D_ONSCR)
		jnz	SHORT @@toend
		push	panel
		call	pcell_set
		xor	ax,ax
		cmp	[si.pn_cel_count],ax
		je	SHORT @@toend
		call	PCellOpen
		push	ds
		push	di
		call	twshow
		mov	ax,1
@@toend:	ret
pcell_show	ENDP

pcell_update	PROC	PASCAL	DIST
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		push	[bx.pn_xl]
		call	twclose
		or	ax,ax
		jz	SHORT @@toend
		push	panel
		call	pcell_set
		push	panel
		call	panel_curobj
		push	dx
		push	ax
		xor	ax,ax
		mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_xl]
		mov	al,[bx.xl_rect.rc_x]
		push	ax
		mov	al,[bx.xl_rect.rc_y]
		push	ax
		mov	bx,WORD PTR panel
		call	[bx.pn_putfcb]
		call	PCellOpen
		mov	bx,WORD PTR panel
		push	[bx.pn_xl]
		call	twshow
		push	panel
		call	panel_putmini
		mov	ax,1
@@toend:	ret
pcell_update	ENDP

pcell_select	PROC	PASCAL	DIST
ARG		panel:	DWORD
		push	panel
		call	panel_curobj
		or	ax,ax
		jz	SHORT @@toend
		push	dx
		push	ax
		call	invert_fb
		or	ax,ax
		jz	SHORT @@toend
		push	panel
		call	pcell_update
		mov	ax,1
@@toend:	ret
pcell_select	ENDP

pcell_setxy	PROC	PASCAL	DIST
ARG		@@pn:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
LOCAL		@@rc:	DWORD
		USES	si,di
		push	@@pn
		call	panel_state
		or	ax,ax
		jnz	SHORT @@do
		jmp	@@toend
@@do:		push	@@pn
		push	@@x
		push	@@y
		call	panel_xycmd
		cmp	ax,PN_XYFILE
		je	SHORT @@InitZ
@@MouseRight:	call	mousep
		cmp	ax,2
		je	SHORT @@mousex
		jmp	@@null
@@mousex:	call	mousex
		mov	di,ax
		call	mousey
		mov	si,ax
		push	@@pn
		push	di
		push	si
		call	panel_xycmd
		cmp	ax,PN_XYFILE
		jne	SHORT @@MouseRight
		push	@@pn
		push	di
		push	si
		call	pcell_setxy
		jmp	@@toend
@@InitZ:	xor	ax,ax
		mov	si,ax
		mov	di,ax
@@CelCount:	mov	bx,WORD PTR @@pn
		mov	ax,[bx.pn_cel_count]
		cmp	di,ax
		jnb	SHORT @@TestZ
		push	[bx.pn_xl]
		push	di
		call	xl_getrect
		mov	WORD PTR @@rc,ax
		mov	WORD PTR @@rc+2,dx
		push	dx
		push	ax
		push	@@x
		push	@@y
		call	rcxyrow
		or	ax,ax
		jnz	SHORT @@Found
		inc	di
		jmp	SHORT @@CelCount
@@Found:	inc	si
@@TestZ:	cmp	si,1
		je	SHORT @@1
		jmp	@@NotFound
@@1:		mov	bx,WORD PTR @@pn
		mov	ax,di
		cmp	ax,[bx.pn_cel_index]
		je	SHORT @@MouseRight2
		mov	[bx.pn_cel_index],ax
		push	@@pn
		call	pcell_update
@@MouseRight2:	call	mousep
		cmp	ax,2
		jne	SHORT @@MouseWait
		push	@@pn
		call	pcell_select
		movzx	ax,@@rc.rc_x
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		mov	al,@@rc.rc_col
		push	ax
		call	mousewait
		push	@@pn
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	pcell_setxy
		jmp	@@toend
@@Move:		call	cmmove
		jmp	SHORT @@True
@@Copy:		call	cmcopy
@@True:		mov	ax,1
		jmp	@@toend
@@MouseWait:	push	@@x
		push	@@y
		push	1
		call	mousewait
		push	@@pn
		call	pcell_move
		cmp	ax,1
		je	SHORT @@Copy
		cmp	ax,2
		je	SHORT @@Move
		mov	di,10
@@MouseClick:	push	16
		call	delay
		call	mousep
		jnz	SHORT @@TestMouse
		dec	di
		jnz	SHORT @@MouseClick
@@TestMouse:	call	mousep
		jz	SHORT @@True
		call	mousex
		cmp	ax,@@x
		jne	SHORT @@True
		call	mousey
		cmp	ax,@@y
		jne	SHORT @@True
		push	@@pn
		push	KEY_ENTER
		call	panel_hndevent
		jmp	SHORT @@True
@@NotFound:	call	mousep
		cmp	ax,2
		jne	SHORT @@null
		push	@@pn
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	panel_xycmd
		cmp	ax,PN_XYFILE
		jne	SHORT @@NotFound
		push	@@pn
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	pcell_setxy
		jmp	SHORT @@toend
@@null:		xor	ax,ax
@@toend:	ret
pcell_setxy	ENDP

_RCFLAG		= (_D_DMOVE or _D_CLEAR or _D_COLOR)

pcell_move	PROC	PASCAL	DIST
ARG		panel:	DWORD
LOCAL		@@q:	WORD,\
		@@copy:	WORD,\
		@@sel:	WORD,\
		@@sc:	DWORD,\
		@@rc:	DWORD,\
		@@b:	DWORD
		USES	si,di

		call	cpanel_findfirst
		or	ax,ax
		jnz	SHORT @@State
@@NoPanels:	jmp	@@toend

@@State:        mov	WORD PTR @@b,ax
		mov	WORD PTR @@b+2,dx

		mov	si,WORD PTR panel
		mov	di,WORD PTR [si.pn_xl]
		mov	eax,[di.xl_rect]
		mov	@@rc,eax

		push	panel
		call	panel_numselected
		mov	@@sel,ax

		call	mousep
		cmp	ax,1
		jne	SHORT @@NoPanels

		mov	@@copy,ax
		les	bx,shift
		test	BYTE PTR es:[bx],3
		jz	SHORT @@rc_col
		dec	@@copy		; == Move

@@rc_col:       mov	ax,@@sel
		or	ax,ax
		jz	SHORT @@NotSelected
		mov	@@rc.rc_col,15
		jmp	SHORT @@IncCol

@@NotSelected:	mov	bx,[si]
		mov	ax,[bx]
		and	ax,_W_DETAIL
		jz	SHORT @@NoDetail
		sub	@@rc.rc_col,26
@@NoDetail:	movzx	ax,@@rc.rc_x
		add	al,@@rc.rc_col
		dec	al
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		call	getxyc
		cmp	al,' '
		jne	SHORT @@EndCol
		dec	@@rc.rc_col
		jmp	SHORT @@NoDetail
@@EndCol:	inc	@@rc.rc_col

@@IncCol:       inc	@@rc.rc_col
		dec	@@rc.rc_x
		push	@@rc
		push	_RCFLAG
		xor	ax,ax
		mov	al,at_background[B_DarkGray]
		or	al,at_foreground[F_Black]
		push	ax
		xor	eax,eax
		push	eax
		push	eax
		call	rcopen
		mov	WORD PTR @@sc,ax
		mov	WORD PTR @@sc+2,dx
		inc	ax
		inc	ax
		mov	cx,@@sel
		or	cx,cx
		jz	SHORT @@wcputs

		push	cx
		push	ds
		push	OFFSET cp_copyselected
		xor	ecx,ecx
		push	ecx
		push	dx
		push	ax
		call	wcputf
		add	sp,14
		jmp	SHORT @@InitQ

@@wcputs:       push	dx
		push	ax
		xor	ax,ax
		push	ax
		mov	al,@@rc.rc_col
		dec	ax
		push	ax
		mov	eax,@@b
		add	ax,fb_name
		push	eax
		call	wcputs

@@InitQ:	mov	@@q,(_RCFLAG or _D_DOPEN)
		push	@@rc
		push	@@q
		push	@@sc
		call	rcshow
		or	@@q,_D_ONSCR

		xor	ax,ax
		mov	cx,ax
		inc	cx
		mov	al,@@rc.rc_x
		add	al,@@rc.rc_col
		dec	al
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		push	cx
		mov	al,' '
		cmp	@@copy,dx
		je	SHORT @@NoCopy
		mov	al,'+'
@@NoCopy:	push	ax
		mov	al,@@rc.rc_x
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		push	cx
		push	' '
		call	scputw
		call	scputw

@@WhileMouseLeft:
		call	mousep
		cmp	ax,1
		je	SHORT @@TestMX
		jmp	@@Close


@@TestMX:	call	mousex
		cmp	al,@@rc.rc_x
		jne	SHORT @@MoveCell
		call	mousey
		cmp	al,@@rc.rc_y
		je	SHORT @@UpdateCell

@@MoveCell:	push	@@rc
		push	@@sc
		push	@@q
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcmove
		mov	WORD PTR @@rc,ax
		mov	WORD PTR @@rc+2,dx

@@UpdateCell:	les	bx,shift
		mov	dl,es:[bx]
		xor	ax,ax

		cmp	ax,@@copy
		je	SHORT @@NoCopy2
		and	dl,3
		jz	SHORT @@WhileMouseLeft
		mov	@@copy,ax
		mov	al,@@rc.rc_x
		add	al,@@rc.rc_col
		dec	al
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		push	1
		push	' '
		call	scputw
		jmp	SHORT @@WhileMouseLeft

@@NoCopy2:	and	dl,3
		jnz	SHORT @@WhileMouseLeft
		inc	ax
		mov	@@copy,ax
		mov	al,@@rc.rc_x
		add	al,@@rc.rc_col
		dec	al
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		push	1
		push	'+'
		call	scputw
		jmp	@@WhileMouseLeft

@@Close:	push	@@rc
		push	@@q
		push	@@sc
		call	rcclose

		push	ds
		mov	bx,[si]
		mov	ax,[bx]

		mov	dx,OFFSET spanel
		and	ax,_W_PANELID
		jnz	SHORT @@PanelA
		add	dx,SIZE PANELS
@@PanelA:       push	ds
		push	dx
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	panel_xycmd
		or	ax,ax
		jz	SHORT @@toend
		mov	ax,1
		cmp	@@copy,0
		jne	SHORT @@toend
		inc	ax
@@toend:	ret
pcell_move	ENDP

xlcopyfile	PROC	PASCAL
ARG		@@src:	DWORD,\
		@@des:	DWORD
		push	OSTDI
		call	oinitst
		jz	SHORT @@toend
		push	OSTDO
		call	oinitst
		jz	SHORT @@free_STDI
		push	@@src
		push	_A_NORMAL
		push	M_RDONLY
		push	A_OPEN
		call	osopen
		cmp	ax,-1
		je	SHORT @@free_STDO
		mov	bx,OSTDI
		mov	[bx.ios_file],ax
		push	@@des
		push	_A_NORMAL
		push	M_WRONLY
		push	A_CREATE
		call	osopen
		cmp	ax,-1
		jne	SHORT @@Copy
		push	OSTDI
		call	oclose
		push	OSTDO
		call	ofreest
		xor	ax,ax
@@toend:	ret
@@free_STDO:	push	OSTDO
		call	ofreest
@@free_STDI:	push	OSTDI
		call	ofreest
		xor	ax,ax
		jmp	SHORT @@toend
@@Copy:         mov	bx,OSTDO
		mov	[bx.ios_file],ax
		xor	eax,eax
		mov	errno,ax
		dec	eax
		push	eax
		call	ocopy
		push	OSTDI
		call	oclose
		call	ofwrite
		push	OSTDO
		call	oclose
		xor	ax,ax
		cmp	ax,errno
		je	SHORT @@ok
		push	@@des
		call	remove
@@ok:		inc	ax
		jmp	SHORT @@toend
xlcopyfile	ENDP

ccell_edit	PROC	PASCAL	DIST
ARG		@@copy:	WORD
LOCAL		@@p:	DWORD,\
		@@b:	DWORD,\
		@@rc:	DWORD,\
		@@name:	BYTE:[WMAXPATH]
		USES	si,di

		push	cpanel
		call	panel_curobj
		or	ax,ax
		jnz	SHORT @@Directory
		jmp	@@toend

@@Directory:	mov	WORD PTR @@b,ax
		mov	WORD PTR @@b+2,dx
		mov	es,dx
		mov	di,ax
		mov	si,es:[di]
		test	si,_A_UPDIR
		jz	SHORT @@Archive
		jmp	@@null

@@Archive:	test	si,_A_ARCHIVE
		jz	SHORT @@InitRC
IFDEF _DZIP_
		mov	ax,si
		and	ax,_A_ARCHIVE
		cmp	ax,_A_DZIP
		je	SHORT @@InitRC
ENDIF
@@notsup:	call	notsup
		jmp	@@toend

@@InitRC:	mov	bx,WORD PTR cpanel
		mov     bx,WORD PTR [bx.pn_xl]
		mov	eax,[bx.xl_rect]
		mov	@@rc,eax

		mov	bx,WORD PTR cpanel
		mov	bx,WORD PTR [bx.pn_wsub]
		push	[bx.ws_path]
		mov	eax,@@b
		add	ax,fb_name
		push	eax
		call	wlongname
		mov	WORD PTR @@p,ax
		mov	WORD PTR @@p+2,dx
IFDEF _DZIP_
		test	si,_A_ARCHIVE
		jz	SHORT @@Local
		jmp	@@InitDZIP
ENDIF
@@Local:	push	ss
		lea	ax,@@name
		push	ax
		push	@@p
		call	strcpy

@@Rename:	lea	bx,@@name
		xor	ax,ax
		cmp	ss:[bx],al
		jne	SHORT @@Edit
		jmp	@@Update

@@Edit:		mov	al,@@rc.rc_x
		push	ax
		mov	al,@@rc.rc_y
		push	ax
		mov	al,@@rc.rc_col
		push	ax
		push	0720h
		call	scputw

		push	ss
		lea	ax,@@name
		push	ax
		push	@@rc
		push	(WMAXPATH-1)
		call	tdedit
		cmp	ax,KEY_ESC
		je	SHORT @@Update
		push	@@p
		push	ss
		lea	ax,@@name
		push	ax
		call	strcmp
		jz	SHORT @@Update

		xor	ax,ax
		cmp	ax,@@copy
		je	SHORT @@OSRename

		test	si,_A_ARCHIVE
		jnz	SHORT @@Update_FCB

		push	@@p
		push	ss
		lea	ax,@@name
		push	ax
		call	xlcopyfile
		jmp	SHORT @@Update_FCB

@@OSRename:
IFDEF _DZIP_
		test	si,_A_ARCHIVE
		jnz	SHORT @@DZRename
ENDIF
		push	@@p
		push	ss
		lea	ax,@@name
		push	ax
		call	rename
IFDEF _DZIP_
		jmp	SHORT @@Update_FCB

@@DZRename:	push	ss
		lea	ax,@@name
		push	ax
		mov	ax,si
		and	ax,_A_FATTRIB
		push	ax
		call	dzipren
ENDIF
@@Update_FCB:   push	cpanel
		call	panel_update_fcb

@@Update:	mov	bx,WORD PTR cpanel
		push	[bx.pn_xl]
		call	twclose

		or	ax,ax
		jz	SHORT @@ok
		push	cpanel
		call	pcell_show

@@ok:		mov	ax,1
@@toend:	ret
@@null:		xor	ax,ax
		jmp	SHORT @@toend

IFDEF _DZIP_
@@InitDZIP:	mov	dx,ds
		push	dx
		push	OFFSET __outfile
		mov	bx,WORD PTR cpanel
		mov	bx,WORD PTR [bx.pn_wsub]
		push	[bx.ws_path]
		push	[bx.ws_file]
		push	ss
		lea	ax,@@name
		push	ax
		push	dx
		push	OFFSET __outpath
		push	@@p
		push	dx
		push	OFFSET __srcfile
		push	dx
		push	OFFSET __outpath
		push	@@p
		push	dx
		push	OFFSET __outpath
		push	[bx.ws_arch]
		call	strcpy
		call	strfcat
		call	strfcat
		call	strfcat
		jmp	@@Rename
ENDIF
ccell_edit	ENDP

XCELL_TEXT	ENDS

		END
