/* CMCOPY.C--
 * Copyright (c) 1999 Hjort Nidudsson
 *
 * Change history:
 * 21 Apr 1999	- Created
 */

#include <io.h>
#include <dir.h>
#include <arch.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <progress.h>
#include <dzmain.h>

const char
cp_ercopy	[] = "There was an error while copying",
cp_enospc	[] = "No space left on device",
cp_recursive	[] = "You tried to recursively copy or move a directory",
cp_needpanel	[] = "You need two file panels to use this command.",
cp_fnisequal	[] = "You can't copy a file to itself",
cp_copyselected	[] = "%d file(s) to",
cp_ermkdir	[] = "Can't create the directory\n%s\n\n'%s'";

extern ROBJ *IDD_COPY;
extern ROBJ *IDD_MOVE;
static DOBJ *dialog;
static int copy_filecount;
static int copy_directorycount;

int copy_jump;
int copy_flag;

int xcopy_file(const char *, wfblk *);
int cmcopyfile(FBLK *, int __virgin);
int return_update_fcb(int __result);

int recursive(char *name, char *src, char *des)
{
	int  length;
	char source[WMAXPATH];
	char target[WMAXPATH];

	strcpy(target, des);
	strcpy(source, wlongpath(src, name));
	strfcat(target, wlongpath(target, NULL), strfn(source));
	length = strlen(source);
	source[length++] = '\\';
	source[length] = '\0';
	return (0 == strnicmp(source, target, length));
}

static int copy_getselected(void)
{
	int q;
	fblk **b;

	b = cpanel->ide->fcb;
	for (q = 0; q < cpanel->fcb_count; q++) {
		if (ISSELECTED(b[q]->flag)) {
			if (ISSUBDIR(b[q]->flag)) {
				if (recursive(b[q]->name, __srcpath, __outpath))
					copy_flag = _CPYRECURSIV;
				copy_directorycount++;
			} else {
				copy_filecount++;
			}
		}
	}
	return copy_filecount + copy_directorycount;
}

static int event_filter(void)
{
	int x,y;

	cmfilter();
	x = dialog->rc.x + 16;
	y = dialog->rc.y + 5;
	if (filter == NULL)
		scputc(x, y, 0, 1, ' ');
	else
		scputc(x, y, 0, 1, 7);
	return _C_NORMAL;
}

static int iddcopy(FBLK *b, int copy)
{
	int x,y;
	DOBJ *d;

	if (copy)
		x = (config.confirm & _C_CONFCOPY);
	else
		x = (config.confirm & _C_CONFMOVE);
	if (x == 0)
		return 1;
	if (copy)
		d = rsopen(IDD_COPY);
	else
		d = rsopen(IDD_MOVE);
	if (d == NULL)
		return 0;
	dialog = d;
	if (copy) {
		filter = NULL;
		d->object[2].proc = event_filter;
	}
	twshow(d);
	x = d->rc.x + 9;
	y = d->rc.y + 2;
	d->object->count = 16;
	if (ISSELECTED(b->flag)) {
		scputf(x, y, 0, 0, cp_copyselected,
			(copy_filecount + copy_directorycount));
		scpath(x - 5, y + 1, 51, __outpath);
		d->object->data = __outpath;
	} else {
		scputc(x, y, 0, 1, '\'');
		scputs(scpath(x + 1, y, 38, b->name) +
			x + 1, y, 0, 0, "' to");
		d->object->data = __outfile;
	}
	if (ISSUBDIR(b->flag)) {
		scpath(x - 5, y + 1, 51, __outpath);
		d->object->data = __outpath;
	}
	if (copy_flag & _CPYOUTARCH) {
		d->object->data = __outfile;
		tdinit(d);
		d->object->flag |= _O_STATE;
	}
	if (copy)
		x = rsevent(IDD_COPY, d);
	else
		x = rsevent(IDD_MOVE, d);
	tdclose(d);
	return (x != 0);
}

int copy_initpath(FBLK *b, int copy)
{
	char *	outp;
	WSUB *  outw;

	copy_jump = 0;
	copy_flag = 0;
	copy_filecount = 0;
	copy_directorycount = 0;

	if ((outp = cpanel_gettarget()) == NULL)
		return stderror(cp_needpanel, EMUSER, 0);

	outw = panela.ide;
	if (cpanel == &panela)
		outw = panelb.ide;

	if (*outw->flag & _W_ARCHIVE) {
		if (copy && (*outw->flag & _W_ARCHIVE) == _W_ZIP)
			copy_flag = _CPYOUTZIP;
#ifdef _DZIP_
		else if (copy && (*outw->flag & _W_ARCHIVE) == _W_DZIP)
			copy_flag = _CPYOUTDZIP;
#endif
		else
			return notsup();
	}

	strcpy(__outpath, wlongpath(outp, NULL));
	strcpy(__srcpath, wlongpath(cpanel->ide->path, NULL));
	strcpy(__srcfile, wlongpath(__srcpath, b->name));

	if (copy_flag & _CPYOUTARCH) {
		strfcat(__outfile, __outpath, outw->file);
		if (outw->arch[0])
			strcpy(__outpath, outw->arch);
		else
			__outpath[0] = 0;
		dostounix(__outpath);
	} else {
		strfcat(__outfile, __outpath, strfn(__srcfile));
	}

	if (ISSELECTED(b->flag)) {
		if (copy_getselected() == 0)
			return copy_flag;
		copy_flag |= _CPYSELECTED;
	} else if (ISSUBDIR(b->flag)) {
		if (recursive(b->name, __srcpath, __outpath))
			copy_flag |= _CPYRECURSIV;
		copy_directorycount = 1;
	} else {
		copy_filecount = 1;
	}
	if ((copy_filecount + copy_directorycount) == 0)
		return 0;
	if (iddcopy(b, copy) == 0)
		return 0;

	if (ISARCHIVE(b->flag)) {
		_ASSERTE(copy_flag & _CPYOUTARCH);
		copy_flag |= _CPYSRCARCH;
		copy_flag &= ~_CPYRECURSIV;
	} else if (0 == strcmp(__outfile, __srcfile)) {
		return stderror(cp_fnisequal, EMUSER, 0);
	}

	if (copy_flag & _CPYRECURSIV)
		return stderror(cp_recursive, EMUSER, 0);
	if ((copy_flag & _CPYOUTARCH) == 0 && getfattr(__outpath) == -1) {
		if (mkdir(__outpath) != 0)
			return ermsg(cp_mkdir, cp_ermkdir, __outpath, sys_errlist[errno]);
	}
	set_confirmflag();
	return 1;
}

void ercopyhndl(void)
{
	if (errno == ENOSPC)
		ermsg(NULL, "%s\n%s\n\n%s", cp_ercopy, __outfile, cp_enospc);
	else
		ermsg(NULL, "%s\n%s", cp_ercopy, __outfile);
}

int oupdate(int ios)
{
	return (progress_update(_ios[ios].total) == 0);
}

#define clock()		*((long *)0x0040006C)

#define USECRCCOPY
//#define SPEEDTEST
// 52-52 no update, no crc
// 52-55 update output - crc
// 54-58 update output + crc
// 58/58 original
int copyfile(long size, int date, int time, char attrib)
{
	int h;
	int result;
#ifdef	SPEEDTEST
	long speed;
#endif
	errno = 0;
	if ((h = oopen(__outfile, M_WRONLY)) == -1) {
		return -1;
	} else if (h == 0) {
		copy_jump = 1;
		return 0;
	}
	if (oopen(__srcfile, M_RDONLY) == -1) {
		oclose(OSTDO);
		remove(__outfile);
		return -1;
	}
	STDO.flag = (IO_USEUPD | IO_UPDTOTAL);
#ifdef	USECRCCOPY
	STDI.flag |= IO_USECRC;
	STDO.flag |= IO_USECRC;
#endif
#ifdef	SPEEDTEST
	speed = clock();
#endif
	result = ocopy(size);
	ofwrite();
#ifdef	SPEEDTEST
	speed = (clock() - speed);
#endif
	oclose(OSTDI);
#ifdef	USECRCCOPY
	if (STDI.bb != STDO.bb) {
		oclose(OSTDO);
		ermsg(NULL, "%s\n%s", cp_ercopy, dos_errlist[4]);
		remove(__outfile);
		return -1;
	}
#endif
	if (result == 0) {
		oclose(OSTDO);
		ercopyhndl();
		remove(__outfile);
		return -1;
	}
	result = progress_update(size);
	if (_ifsmgr) {
		oclose(OSTDO);
		wsetwrdate(__outfile, date, time);
	} else {
		setfdate(STDO.file, date, time);
		oclose(OSTDO);
	}
	if (ISRDONLY(attrib) && (cflag & _C_CDCLRDONLY)
		&& (*cpanel->flag & _W_CDROOM))
		attrib &= ~_A_RDONLY;
	setfattr(__outfile, attrib & _A_FATTRIB);
#ifdef	SPEEDTEST
	stdmsg("Time Ticks", "%lu", speed);
#endif
	return result;
}

int xcopy_subdir(const char *p)
{
	char *	q;
	char 	b[WMAXPATH];
	int 	result;

	q = (char *)p + strlen(__srcpath);
	if (*q == '\\')
		q++;
	_ASSERTE(*q == 0);
	strcpy(b, __outpath);

	if (copy_flag & _CPYOUTARCH) {
#ifdef _DZIP_
		if (copy_flag & _CPYOUTDZIP) {
			strcpy(__srcfile, p);
			dzipadd(0L, dwdosdate(), twdostime(), getfattr(p));
		} else {
#endif
			if (__outpath[0])
				strcat(__outpath, "/");
			strcat(__outpath, q);
			dostounix(__outpath);
			__srcfile[0] = 0;
#ifdef _DZIP_
		}
#endif
		if (copy_flag & _CPYOUTZIP)
			wzipadd(0L, dwdosdate(), twdostime(), getfattr(p));
	} else {
		strfcat(__outpath, NULL, q);
		if (mkdir(__outpath) != -1) {
			if (setfattr(__outpath, 0) == 0)
				setfattr(__outpath, getfattr(p) & ~_A_SUBDIR);
		}
	}
	result = scan_files(p);
	strcpy(__outpath, b);
	return result;
}

static int cmcopydirectory(FBLK *b)
{
	char directory[WMAXPATH];

	if (progress_set(b->name, __outpath, 0))
		return _ER_USERABORT;
	if ((copy_flag & _CPYOUTARCH) == 0)
		mkdir(__outpath);
	strfcat(directory, __srcpath, b->name);
	return scansub(directory, cp_stdmask, 1);
}

static int cmcopyselected(FBLK *b)
{
	do {
		if (ISARCHIVE(b->flag)) {
			if (wsdecomp(cpanel->ide, b, __outpath))
				return 0;
		} else if (ISSUBDIR(b->flag)) {
			if (cmcopydirectory(b))
				return 0;
		} else if (cmcopyfile(b, 0)) {
			return 0;
		}
		cpanel_deselect(b);
	} while ((b = panel_ffselected(cpanel)) != NULL);
	return 1;
}

int cmcopy(void)
{
	FBLK *b;
	int result;

	result = 0;
	if (!(b = cpanel_findfirst()))
		return result;
	if (copy_initpath(b, 1) == 0)
		return result;
	progress_open(cp_copy, cp_copy);
	fp_fileblock = xcopy_file;
	fp_directory = xcopy_subdir;
	if (copy_flag & _CPYOUTARCH)
		dostounix(__outpath);
	if (ISSELECTED(b->flag)) {
		result = cmcopyselected(b);
	} else if (ISSUBDIR(b->flag)) {
		if (ISARCHIVE(b->flag))
			result = wsdecomp(cpanel->ide, b, __outpath);
		else
			result = cmcopydirectory(b);
	} else { /* outfile may be edited in dialog COPY */
		result = cmcopyfile(b, 1);
	}
	return return_update_fcb(result);
}

/******** Resource begin COPY *
	{ 0x0C1C,   4,   0, { 8, 5,59, 7} },
	{ 0x0004,   0, 'N', { 4, 3,51, 1} },
	{ 0x0000,   0, 'O', { 4, 5, 8, 1} },
	{ 0x4000,   0, 'F', {15, 5,10, 1} },
	{ 0x0200,   0, 'C', {44, 5,10, 1} },
********* Resource data  *******************/
static int COPY_RC[] = {
	0x03D1,0x0C1C,0x0004,0x0508,0x073B,0x0004,0x4E00,0x0304,
	0x0133,0x0000,0x4F00,0x0504,0x0108,0x4000,0x4600,0x050F,
	0x010A,0x0200,0x4300,0x052C,0x010A,0x21F0,0x5A50,0x19F0,
	0xF050,0x2A7A,0x33F0,0xF007,0x2A43,0x03F0,0x5C50,0x04F0,
	0x2050,0x2A2A,0x5050,0xF05C,0x5007,0xF020,0x2A12,0x5050,
	0xF05C,0x5007,0xF020,0x2A09,0x08F0,0xF020,0x2A03,0x0AF0,
	0xF020,0x2A13,0x0AF0,0xF020,0x2A04,0x1BF0,0x4320,0x706F,
	0xF079,0x205B,0x6F43,0x7970,0x37F0,0xF020,0xFA33,0x45F0,
	0x4320,0x706F,0x2079,0xDC20,0x04F0,0x4620,0x6C69,0x6574,
	0x2072,0xDC20,0x14F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,
	0x09F0,0xF020,0xDF08,0x03F0,0xF020,0xDF0A,0x13F0,0xF020,
	0xDF0A,0x04F0,0x2A20,
}; //	182 byte
ROBJ *IDD_COPY = (ROBJ *)&COPY_RC;
/******** Resource end   COPY */

/******** Resource begin MOVE *
	{ 0x4C1C,   3,   0, { 8, 5,59, 7} },
	{ 0x0004,   0, 'N', { 4, 3,51, 1} },
	{ 0x0000,   0, 'M', { 4, 5, 8, 1} },
	{ 0x0200,   0, 'C', {15, 5,10, 1} },
********* Resource data  *******************/
static int MOVE_RC[] = {
	0x03C1,0x4C1C,0x0003,0x0508,0x073B,0x0004,0x4E00,0x0304,
	0x0133,0x0000,0x4D00,0x0504,0x0108,0x0200,0x4300,0x050F,
	0x010A,0x21F0,0x5A50,0x19F0,0xF050,0x2A7A,0x33F0,0xF007,
	0x2A43,0x5050,0xF05C,0x5005,0x2A20,0x502A,0x5C50,0x07F0,
	0x2050,0x26F0,0xF02A,0x2008,0x03F0,0xF02A,0x200A,0x21F0,
	0xF02A,0x201B,0x6F4D,0x6576,0x5BF0,0x4D20,0x766F,0xF065,
	0x2037,0x33F0,0xF0FA,0x2045,0x6F4D,0x6576,0x2020,0xF0DC,
	0x2004,0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2026,0x08F0,
	0xF0DF,0x2003,0x0AF0,0xF0DF,0x2021,0x2A2A,
}; //	140 byte
ROBJ *IDD_MOVE = (ROBJ *)&MOVE_RC;
/******** Resource end   MOVE */
