/* WSOPEN.C--
 * Copyright (c) 2004 Hjort Nidudsson
 *
 * Change history:
 * 10 Nov 2008	- memset --> memzero
 * 06 Jun 2004	- Created
 */
#include <wsub.h>
#include <alloc.h>
#include <string.h>

int wsopen(WSUB *p)
{
	int size;

	size = (sizeof(void *) * p->maxfb);
	if ((p->fcb = malloc(size)) == NULL)
		return 0;
	memzero(p->fcb, size);
	return 1;
}

int wsclose(WSUB *p)
{
	int result;

	result = wsfree(p);
	free(p->fcb);
	p->fcb = NULL;
	return result;
}
