/*
 * WSINIT.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <disk.h>
#include <errno.h>

int wsinit(WSUB *p)
{
	int drive;
	int result;

	if (*p->path == 0 || p->path[1] != ':')
		drive = getdrv();
	else
		drive = p->path[0] - 'A';
	chdrv(_disk_init(drive));
	if (*p->path == 0)
		fullpath(p->path, 0);
	else if (p->path[1] == ':' && chdir(p->path))
		fullpath(p->path, 0);
	result = wssetflag(p);
	if (result == 0) {
		ermsg(NULL, "error init path:\n'%s'", p->path);
		return wslocal(p);
	}
	if (result == 1 || result == 3 /*network*/)
		return 1;
	return wslocal(p);
}