/*
 * WSFLAG.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <disk.h>

int wssetflag(WSUB *p)
{
	WSSetLocal(p);
	if (p->path[1] == ':') {
		switch (_disk_type(p->path[0] - 'A')) {
		case _DISK_LOCAL:
			return 1;
		case  _DISK_FLOPPY:
			*p->flag |= _W_FLOPPY;
			return 2;
		case  _DISK_NETWORK:
			*p->flag |= _W_NETWORK;
		case  _DISK_SUBST:
			wscdroom(p);
			return 2;
		}
	} else if (p->path[1] == '\\') {
		*p->flag |= _W_NETWORK;
		return 3;
	}
	return 0;
}