/*
 * WCPUSHST.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <rect.h>
#include <wchar.h>
#include <color.h>
#include <bios.h>

static int visible = 0;
static RECT stline(void)
{
	RECT rc;

	rc.x = 0;
	rc.y = *__egaline;
	rc.col = 80;
	rc.row = 1;
	return rc;
}

void wcpushst(WCHR far *p, const char *cp)
{
	RECT rc;

	rc = stline();
	if (visible == 1)
		rcxchg(rc, p);
	wcputw(p, 80, MKW(at_Menus, ' '));
	p[18].ch = 179;
	wcputs(&p[1], 80, 0, cp);
	rcxchg(rc, p);
	visible = 1;
}

void wcpopst(WCHR far *p)
{
	rcxchg(stline(), p);
	if (visible)
		visible = 0;
	else
		visible = 1;
}