;
; TDINITOB.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE 	clib.inc
INCLUDE 	dialog.inc

EXTRN		tclrascii: BYTE

PPROC		tdinitobj
USES		DS,si,di
LOCAL		oseg:	WORD,\
		offs:	WORD,\
		dcol:	WORD
ARG		dobj:	DWORD,\
		tobj:	DWORD
		call	__mshide
		les	bx,dobj
		movzx	ax,ES:[bx.dl_rect.rc_col]
		add	ax,ax
		mov	dcol,ax
		test	ES:[bx.dl_flag],_D_ONSCR
		jz	SHORT get_wp
		mov	al,80
		mov	ah,50
		push	ax
		mov	al,ES:[bx.dl_rect.rc_x]
		mov	ah,ES:[bx.dl_rect.rc_y]
		les	bx,tobj
		add	al,ES:[bx.dl_rect.rc_x]
		add	ah,ES:[bx.dl_rect.rc_y]
		push	ax
		call	rcsprc
		jmp	SHORT switch_flag
get_wp:		push	ES:[bx.dl_wp]
		xor	ax,ax
		mov	al,ES:[bx.dl_rect.rc_col]
		les	bx,tobj
		push    ES:[bx.to_rect]
		push	ax
		call	rcbprc
switch_flag:	mov	oseg,dx
		mov	offs,ax
		movzx	cx,ES:[bx.to_rect.rc_col]
		mov	ax,ES:[bx]
		mov	si,ax
		and	si,15
		cld
		cmp	si,_O_PBUTT
		jz	SHORT O_PBUTT
		cmp	si,_O_RBUTT
		jz	SHORT O_RBUTT
		cmp	si,_O_CHBOX
		jz	SHORT O_CHBOX
		cmp	si,_O_TEDIT
		jz	SHORT O_TEDIT
		cmp	si,_O_MENUS
		jz	SHORT O_MENUS
		cmp	si,_O_XCELL
		jz	SHORT O_XCELL
		jmp	SHORT O_FALSE
O_PBUTT:        mov	DS,dx
		mov	si,offs
		and	ax,_O_DEACT
		mov	di,ax
		cld
pb_nextw:	lodsw
		and	ax,0F00h
		or	di,di
		jz	SHORT pb_act
		or	ax,ax
		jnz	SHORT pb_loop
		and	BYTE PTR DS:[si-1],0F0h
		or	BYTE PTR DS:[si-1],8
		jmp	SHORT pb_loop
pb_act:         cmp	ah,8
		jnz	SHORT pb_loop
		and	BYTE PTR DS:[si-1],0F0h
pb_loop:        dec	cx
		jnz	SHORT pb_nextw
		jmp	SHORT O_TOEND
O_RBUTT:	and	ax,_O_RADIO
		jz	SHORT rd_clear
		mov	al,7
		jmp	SHORT rd_put
rd_clear:	mov	al,' '
rd_put:		mov	bx,offs
		mov	dx,oseg
		mov	ES,dx
		mov	ES:[bx+2],al
		jmp	SHORT O_TOEND
O_CHBOX:	and	ax,_O_FLAGB
		jz	SHORT rd_clear
		mov	al,'x'
		jmp	SHORT rd_put
O_FALSE:	xor	ax,ax
		jmp	SHORT toend
O_TEDIT:	call	INITTEDIT
		jmp	SHORT O_TOEND
O_MENUS:	test	ax,_O_FLAGB
		jz	SHORT me_testradio
		mov	al,175
		jmp	SHORT me_put
me_testradio:	and	ax,_O_RADIO
		jz	SHORT O_TOEND
		mov	al,7
me_put:		mov	bx,offs
		mov	dx,oseg
		mov	ES,dx
		mov	ES:[bx-2],al
		jmp	SHORT O_TOEND
O_XCELL:        mov	di,offs
		lds	si,ES:[bx.to_data]
		mov	ES,dx
		mov	ax,ES:[di]
		mov	al,' '
		mov	dx,cx
	rep	stosw
		mov	cx,dx
		mov	ax,DS
		or	ax,ax
		jz	SHORT O_TOEND
		mov	di,offs
		add	di,2
		dec	cx
		call	put_textline
O_TOEND:	mov	ax,1
toend:          mov	di,ax
		call	__msshow
		mov	ax,di
		ret
PEND		tdinitobj

_TEXT		SEGMENT

INITTEDIT:	mov	dx,ax
		mov	dl,tclrascii
		lds	si,ES:[bx.to_data]
		and	ax,_O_DEACT
		jz	SHORT isactive
		xor	si,si
isactive:	movzx	di,ES:[bx.to_rect.rc_row]
		movzx	ax,ES:[bx.to_count]
		shl	ax,4
		mov	bx,ax
		mov	ax,oseg
		mov	ES,ax
		mov	al,dl
		mov	dx,di
		mov	di,offs
		mov	ah,ES:[di+1]
		mov	offs,ax
		mov	oseg,cx
do_line:        push	di
		rep	stosw
		pop	di
		mov	cx,oseg
		push	si
		push	di
		or	si,si
		jz      SHORT no_textline
		call	put_textline
no_textline:	mov	cx,oseg
		mov	ax,ES
		cmp	ax,0B800h
		pop	di
		pop	si
		jz	SHORT screen_line
		add	di,dcol
		jmp	SHORT next_line
screen_line:	add	di,160
next_line:	dec	dx
		jz	SHORT endtedit
		mov	ax,offs
		add	si,bx
		jmp	SHORT do_line
endtedit:	ret

put_textline:	lodsb
		or	al,al
		jz	SHORT end_putext
		stosb
		inc	di
		dec	cx
		jnz	SHORT put_textline
end_putext:	ret

_TEXT		ENDS

		END