/*
 * ATOL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <stdlib.h>

long atol(const char *p)
{
	int  c;
	int  sign;
	long total;

	while (*p == ' ')
		++p;
	c = (int)(unsigned char)*p++;
	sign = c;
	if (c == '-' || c == '+')
		c = (int)(unsigned char)*p++;
	total = 0;
	while (c >= '0' && c <= '9') {
		total = 10 * total + (c - '0');
		c = (int)(unsigned char)*p++;
	}
	if (sign == '-')
		return -total;

	return total;
}