/*
 * PERROR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <string.h>

#define err_msg(m) sys_errlist[(((m)<0)||((m)>=sys_nerr)?sys_nerr:(m))]

static char seperator[] = ": ";
static char newline[] = "\r";

void perror(const char *string)
{
	if (string != NULL && string[0] != 0) {
		write(2, string, strlen(string));
		write(2, seperator, 2);
	}
	write(2, err_msg(errno), strlen(err_msg(errno)));
	write(2, newline, 1);
}