/*
 * FREAD.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>

size_t fread(void *buffer, size_t size, size_t num, FILE *o)
{
	char *p;
	unsigned total;
	unsigned count;
	unsigned bufsize;
	unsigned nbytes;
	unsigned nread;
	int c;

	p = (char *)buffer;
	if ((count = total = size * num) == 0)
		return 0;
	if (anybuf(o))
		bufsize = o->bufsize;
	else
		bufsize = _MAXIOBUF;

	while (count != 0) {
		if (anybuf(o) && o->cnt != 0)	{
			nbytes = (count < (unsigned)o->cnt) ? count : o->cnt;
			memcpy(p, o->bp, nbytes);
			count  -= nbytes;
			o->cnt -= nbytes;
			o->bp  += nbytes;
			p      += nbytes;
		} else if (count >= bufsize) {
			nbytes = (bufsize ? (count - count % bufsize) : count);
			nread = read(_fileno(o), p, nbytes);
			if (nread == 0) {
				o->flag |= _IOEOF;
				return (total - count) / size;
			} else if (nread == (unsigned)-1) {
				o->flag |= _IOERR;
				return (total - count) / size;
			}
			count -= nread;
			p += nread;
		} else {
			if ((c = _filebuf(o)) == EOF)
				return (total - count) / size;
			*p++ = (char) c;
			--count;
			bufsize = o->bufsize;
		}
	}
	return num;
}
