/*
 * FFLUSH.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>

#define FLUSHALL        1
#define SFLUSHNULL      0

extern int _exitflag;
int _fcloseall(void);

static int flsall(int);

int  fflush(FILE *);
int  _flush(FILE *);
int  _flushall(void);
void _endstdio(void);

int fflush(FILE *o)
{
	if (o == NULL)
		return flsall(SFLUSHNULL);
	if (_flush(o) != 0)
		return EOF;
	return 0;
}

int _flushall(void)
{
	return flsall(FLUSHALL);
}

int flsall(int flushflag)
{
	FILE *o = _iob;
	int count = 0;
	int result = 0;

	for (; o <= _lastiob; o++) {
		if (inuse(o)) {
			if (flushflag == FLUSHALL) {
				if (_flush(o) != EOF)
					count++;
			}
		} else if ((flushflag == SFLUSHNULL) && (o->flag & _IOWRT)) {
			if (_flush(o) == EOF)
				result = EOF;
		}
	}
	if (flushflag == FLUSHALL)
		return count;
	return result;
}

void _endstdio(void)
{
	_flushall();
	if (_exitflag)
		_fcloseall();
}

#pragma exit _endstdio 29
