/*
 * RCOPEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <rect.h>
#include <wchar.h>

#define _D_COLORTYPE	0x01C0
#define _D_NOCOLOR	0x0000

void *rcopen(RECT rc, int flag, char attrib, const char *name, void *p)
{
	if ((flag & _D_MYBUF) == 0) {
		if ((p = rcalloc(rc, flag)) == NULL)
			return NULL;
	}
	rcread(rc, p);
	if ((flag & _D_COLORTYPE) == _D_NOCOLOR)
		return p;
	switch (flag & _D_COLORTYPE) {
	case (_D_CLEAR | _D_COLOR):
		wcputw(p, rc.col * rc.row, MKW(attrib, ' '));
		break;
	case _D_CLEAR:
		wcputc(p, rc.col * rc.row, ' ');
		break;
	case _D_COLOR:
		wcputa(p, rc.col * rc.row, attrib);
		break;
	case _D_BACKG:
		wcputbg(p, rc.col * rc.row, attrib);
		break;
	case _D_FOREG:
		wcputfg(p, rc.col * rc.row, attrib);
	default:
		break;
	}
	if (name != NULL)
		wctitle(p, rc.col, name);
	return p;
}
