; OUNGETC.ASM--
; Copyright (c) 2008 Hjort Nidudsson
;
; Change history:
; 21 Aug 2008	- int oungetc(void) [char..EOF]

include 	clib.inc
include 	io.inc
include 	iost.inc

PPROC		oungetc
		USES	si,di
		mov	si,OSTDI
		xor	ax,ax
		cmp	ax,[si.ios_i]
		jz	SHORT @@seekback
@@unget:        dec	[si.ios_i]
		mov	ax,[si.ios_i]
		les	si,[si.ios_bp]
		add	si,ax
		mov	al,es:[si]
		or	si,si		; Clear ZERO flag
@@toend:	ret
@@seekback:     test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@memseek
		mov	cx,ax		; Get current offset
		mov	dx,ax
		mov	ax,4201h
		mov	bx,[si.ios_file]
		int	21h
		jc	SHORT @@eof
		push	dx
		push	ax
		pop	edx		; current offset to EDX
@@memset:	movzx	eax,[si.ios_c]	; last read size to EAX
		cmp	eax,edx         ; >= current offset ?
		ja	SHORT @@ioerr	; stream not align if above
		je	SHORT @@eof	; EOF == top of file
		sub	edx,eax		; adjust offset to start
		movzx	eax,[si.ios_memz]
		cmp	eax,edx		; MAX buffer >= start offset
		jae	SHORT @@seekset ; --> to top of file
		sub	edx,eax		; offset -= sizeof(buffer)
@@seek:         push	ax		; save byte size back
		push	edx		; seek to offset and read MAX
		push	SEEK_SET
		call	oseek
		pop	ax              ; restore byte size
		jz	SHORT @@eof	; --> OS error ?
		cmp     ax,[si.ios_c]	; read size >= byte size
		ja	SHORT @@ioerr   ; --> error in stream
		mov     [si.ios_c],ax	; reset read count to size
		mov     [si.ios_i],ax   ; set index to count
		jmp	SHORT @@unget   ; jump back and read last char
@@seekset:	mov	eax,edx		; set AX to byte size back
		xor	edx,edx         ; EDX to top of file
		jmp	SHORT @@seek
@@ioerr:        or	[si.ios_flag],IO_ERROR
@@eof:		mov	ax,-1
		xor	si,si
		jmp	SHORT @@toend
@@memseek:      movzx	edx,[si.ios_c]	; last read size + offs
		add	edx,[si.ios_offs]
		jmp	SHORT @@memset
PEND            oungetc

		END
