/*
 * WRITE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>

#define LF	'\n'
#define CR	'\r'
#define CTRLZ	26

int write(int h, const void *b, unsigned len)
{
	int w;
	int count;
	int result;
	char ch;
	char *p, *q;
	char lb[1025];

	if (len == 0)
		return 0;
	if (h >= _nfile) {
		errno = EBADF;
		doserrno = 0;
		return -1;
	}
	if (_osfile[h] & FH_APPEND)
	     (void)lseek(h, 0, SEEK_END);

	result = count = 0;
	if (_osfile[h] & FH_TEXT) {
		p = (char *)b;
		while ((unsigned)(p - (char *)b) < len) {
			q = lb;
			while (q - lb < 1024 && (unsigned)(p - (char *)b) < len) {
				if (*p == LF)
					*q++ = CR;
				*q++ = *p++;
				count++;
			}
			if ((w = oswrite(h, lb, q - lb)) > 0) {
				if (w < q - lb)
					break;
			} else {
				result++;
				break;
			}
		}
	} else {
		if ((w = oswrite(h, b, len)) > 0) {
			result = 0;
			count = w;
		} else {
			result++;
		}
	}
	if (count == 0) {
		if (result) {
			if (doserrno == 5) /* access denied */
				errno = EBADF;
			return -1;
		} else if ((_osfile[h] & FH_DEVICE) && *(char *)b == CTRLZ) {
			return 0;
		}
		errno = ENOSPC;
		doserrno = 0;
		return -1;
	}
	return count;
}
