/* FILTEDIT.C--
 * Copyright (c) 2008 Hjort Nidudsson
 *
 * Change history:
 * 12 Nov 2008	- Created
 */

#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <filter.h>
#include <dialog.h>
#include <stdio.h>

const char cp_filter[] = "Filter";
extern ROBJ *IDD_OperationFilters;

enum RCOperationFilters {
	ID_INCLUDE,
	ID_EXCLUDE,
	ID_AFTER,
	ID_BEFORE,
	ID_GREATER,
	ID_LESS,
	ID_RDONLY,
	ID_HIDDEN,
	ID_SYSTEM,
	ID_VOLID,
	ID_SUBDIR,
	ID_ARCH,
	ID_OK,
	ID_CLEAR,
	ID_LOAD,
	ID_CANCEL
};

static int event_clearfilter(void)
{
	DOBJ *d;
	TOBJ *o;

	d = tdialog;
	o = d->object;
	*(char *)o[ID_AFTER].data = 0;
	*(char *)o[ID_BEFORE].data = 0;
	*(char *)o[ID_GREATER].data = 0;
	*(char *)o[ID_LESS].data = 0;
	memzero(filter, sizeof(FILT));
	strcpy(filter->include, cp_stdmask);
	filter->flag = 0xFFFF;
	tdsetbitflag(&o[ID_RDONLY], 6, _O_FLAGB, 0xFFFF);
	return _C_REOPEN;
}

int filter_edit(FILT *p, GCMD *keys)
{
	DOBJ *d;
	TOBJ *o;

	filter = NULL;
	if ((d = rsopen(IDD_OperationFilters)) == NULL)
		return _C_ESCAPE;
	o = d->object;
	o[ID_INCLUDE].count = 8;
	o[ID_INCLUDE].data = p->include;
	o[ID_EXCLUDE].count = 8;
	o[ID_EXCLUDE].data = p->exclude;
	o[ID_CLEAR].proc = event_clearfilter;
	if (keys) {
		o[ID_LOAD].data = keys;
		o[ID_LOAD].proc = keys->proc;
		o[ID_LOAD].flag &= ~_O_STATE;
	}
	if (p->min_date)
		dwtolstr(o[ID_AFTER].data, p->min_date);
	if (p->max_date)
		dwtolstr(o[ID_BEFORE].data, p->max_date);
	if (p->min_size)
		sprintf(o[ID_GREATER].data, "%lu", p->min_size);
	if (p->max_size)
		sprintf(o[ID_LESS].data, "%lu", p->max_size);
	tdsetbitflag(&o[ID_RDONLY], 6, _O_FLAGB, p->flag);
	filter = p;
	tdinit(d);
	if (tdevent(d) == 0) {
		tdclose(d);
		filter = NULL;
		return _C_NORMAL;
	}
	p->min_date = 0;
	p->max_date = 0;
	if (*(char *)o[ID_AFTER].data)
		p->min_date = strtodw(o[ID_AFTER].data);
	if (*(char *)o[ID_BEFORE].data)
		p->max_date = strtodw(o[ID_BEFORE].data);
	p->min_size = atol(o[ID_GREATER].data);
	p->max_size = atol(o[ID_LESS].data);
	p->flag = tdgetbitflag(&o[ID_RDONLY], 6, _O_FLAGB) | 0xFFC0;
	tdclose(d);
	return _C_NORMAL;
}

/******** Resource begin OperationFilters *
	{ 0x041C,  16,  12, {10, 4,61,16} },
	{ 0x0004,   0, 'I', {12, 3,45, 1} },
	{ 0x0004,   0, 'E', {12, 4,45, 1} },
	{ 0x0004,   2, 'F', {12, 7,16, 1} },
	{ 0x0004,   2, 'B', {12, 8,16, 1} },
	{ 0x0004,   2, 'V', {41, 7,16, 1} },
	{ 0x0004,   2, 'W', {41, 8,16, 1} },
	{ 0x0022,   0, 'R', { 4,11,13, 1} },
	{ 0x0022,   0, 'H', { 4,12,10, 1} },
	{ 0x0022,   0, 'Y', {22,11,10, 1} },
	{ 0x8002,   0,   0, {22,12,10, 1} },
	{ 0x8022,   0,   0, {40,11,16, 1} },
	{ 0x0022,   0, 'A', {40,12,11, 1} },
	{ 0x0000,   0, 'O', { 3,14, 6, 1} },
	{ 0x4000,   0, 'L', {13,14, 9, 1} },
	{ 0xD000,   0, 'D', {26,14, 8, 1} },
	{ 0x0200,   0, 'C', {47,14,10, 1} },
********* Resource data  *******************/
static int OperationFilters_RC[] = {
	0x098B,0x041C,0x0C10,0x040A,0x103D,0x0004,0x4900,0x030C,
	0x012D,0x0004,0x4500,0x040C,0x012D,0x0004,0x4602,0x070C,
	0x0110,0x0004,0x4202,0x080C,0x0110,0x0004,0x5602,0x0729,
	0x0110,0x0004,0x5702,0x0829,0x0110,0x0022,0x5200,0x0B04,
	0x010D,0x0022,0x4800,0x0C04,0x010A,0x0022,0x5900,0x0B16,
	0x010A,0x8002,0x0000,0x0C16,0x010A,0x8022,0x0000,0x0B28,
	0x0110,0x0022,0x4100,0x0C28,0x010B,0x0000,0x4F00,0x0E03,
	0x0106,0x4000,0x4C00,0x0E0D,0x0109,0xD000,0x4400,0x0E1A,
	0x0108,0x0200,0x4300,0x0E2F,0x010A,0x3DF0,0xF050,0x2A7E,
	0xF03F,0x2A07,0x2DF0,0xF007,0x2A08,0xF03F,0x2A07,0x2DF0,
	0xF007,0x2A83,0xF02E,0x2A06,0x10F0,0xF007,0x2A08,0xF02E,
	0x2A04,0x10F0,0xF007,0x2A08,0xF02E,0x2A07,0x10F0,0xF007,
	0x2A09,0xF02E,0x2A03,0x10F0,0xF007,0x2A86,0xF02E,0x2A12,
	0xF02E,0x2A0C,0x0DF0,0xF028,0x2A10,0xF02E,0x2A0D,0x09F0,
	0xF028,0x2A0D,0xF02E,0x2A50,0x5050,0xF05C,0x5003,0xF020,
	0x2A03,0x03F0,0x5C50,0x05F0,0x2050,0x03F0,0xF02A,0x5805,
	0x585C,0x2058,0x0CF0,0x502A,0x5C50,0x07F0,0x2050,0x07F0,
	0xF02A,0x2006,0x04F0,0xF02A,0x2009,0x04F0,0xF02A,0x2008,
	0x0DF0,0xF02A,0x200A,0x03F0,0xF02A,0x2016,0x704F,0x7265,
	0x7461,0x6F69,0x206E,0x6946,0x746C,0x7265,0x56F0,0xDA20,
	0x37F0,0xBFC4,0x04F0,0xB320,0x4920,0x636E,0x756C,0x6564,
	0x2FF0,0xB320,0x04F0,0xB320,0x4520,0x6378,0x756C,0x6564,
	0x2FF0,0xB320,0x04F0,0xC020,0x37F0,0xD9C4,0x04F0,0xDA20,
	0x4620,0x6C69,0x2065,0x6164,0x6574,0xF020,0xC40F,0x20BF,
	0x20DA,0x6946,0x656C,0x7320,0x7A69,0x2065,0x0FF0,0xBFC4,
	0x04F0,0xB320,0x4120,0x7466,0x7265,0x14F0,0xB320,0xB320,
	0x4120,0x6F62,0x6576,0x14F0,0xB320,0x04F0,0xB320,0x4220,
	0x6665,0x726F,0xF065,0x2013,0x20B3,0x20B3,0x6542,0x6F6C,
	0xF077,0x2014,0xF0B3,0x2004,0xF0C0,0xC41A,0x20D9,0xF0C0,
	0xC41A,0xF0D9,0x2004,0x20DA,0x7441,0x7274,0x6269,0x7475,
	0x2065,0x6966,0x746C,0x7265,0x2073,0x24F0,0xBFC4,0x04F0,
	0xB320,0x5B20,0x5D78,0x5220,0x6165,0x2064,0x6E4F,0x796C,
	0x05F0,0x5B20,0x5D78,0x5320,0x7379,0x6574,0xF06D,0x2008,
	0x785B,0x205D,0x6944,0x6572,0x7463,0x726F,0xF079,0x2005,
	0xF0B3,0x2004,0x20B3,0x785B,0x205D,0x6948,0x6464,0x6E65,
	0x08F0,0x5B20,0x5D20,0x5620,0x6C6F,0x6469,0x09F0,0x5B20,
	0x5D78,0x4120,0x6372,0x6968,0x6576,0x07F0,0xB320,0x04F0,
	0xC020,0x37F0,0xD9C4,0x07F0,0x4F20,0x206B,0xDC20,0x05F0,
	0x4320,0x656C,0x7261,0x2020,0xF0DC,0x2005,0x6F4C,0x6461,
	0x2020,0xF0DC,0x200E,0x6143,0x636E,0x6C65,0x2020,0xF0DC,
	0x2007,0x06F0,0xF0DF,0x2004,0x09F0,0xF0DF,0x2004,0x08F0,
	0xF0DF,0x200D,0x0AF0,0xF0DF,0x2003,0x2A2E,
}; //	668 byte
ROBJ *IDD_OperationFilters = (ROBJ *)&OperationFilters_RC;
/******** Resource end   OperationFilters */
