/*
 * DRVSELEC.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 *
 *  int drvselect(const char *info);
 *  arg: -- "Select disk"
 *
 *  returns selected drive if successful (A = 1),
 *  returns 0 if unsuccessful.
 */

#include <dir.h>
#include <disk.h>
#include <errno.h>
#include <string.h>
#include <dialog.h>

static char pb[] = "&A";

int _disk_select(const char *info)
{
	int  q,id;
	int  result;
	DOBJ dl;
	TOBJ di[32];

	result = 0;
	if (sys_erflag + sys_erdrive + sys_ercode == 0)
		result = getdrv();
	dl.index = 0;
	dl.count = 0;
	for (q = 0; q < MAXDRIVES; q++) {
		if (_disk_type(q)) {
			id = dl.count++;
			di[id].flag = _O_PBUTT;
			if (q == result)
				dl.index = dl.count - 1;
			di[id].ascii  = q + 'A';
			di[id].data   = pb;
			di[id].rc.col = 5;
			di[id].rc.row = 1;
			di[id].rc.x   = 4 + ((id % 8) * 7);
			di[id].rc.y   = 2 + ((id >> 3) << 1);
		}
	}
	dl.flag   = _D_STDDLG;
	dl.rc.col = 63;
	dl.rc.x   = 8;
	dl.rc.y   = 9;
	dl.rc.row = 5 + ((id >> 3) << 1);
	if (id < 8) {
		dl.rc.col = 14 + (id * 7);
		dl.rc.x = ((80 - dl.rc.col) >> 1);
	}
	dl.object = &di[0];
	result   = 0;
	if (twopen(&dl, at_Dialog, info)) {
		for (q = 0; q < dl.count; q++) {
			pb[1] = di[q].ascii;
			wcpbutt(rcbprc(dl.wp, di[q].rc, dl.rc.col), dl.rc.col, di[q].rc.col, pb);
		}
		result = tdmodal(&dl);
	}
	if (result)
		return di[dl.index].ascii - '@';
	return 0;
}

//#define TEST
#ifdef TEST

int _disk_type(int q)
{
	return q < MAXDRIVES;
}

void main(void)
{
    _disk_select("Debug MAXDRIVES");
}

#endif
