/*
 * CONFIRMS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <arch.h>

#define ID_DELETE	1
#define ID_DELETEALL	2
#define ID_SKIPFILE	3

int confirm_delete_sub(const char *name)
{
	if (confirmflag & CFDIRECTORY) {
		switch (confirm_delete(name, MSG_DELSINGEL)) {
		case ID_DELETEALL:
			confirmflag &= ~(CFDIRECTORY|CFDELETEALL);
		case ID_DELETE:
			return 1;
		case ID_SKIPFILE:
			return 0;
		default:
			return -1;
		}
	}
	return 1;
}