/*
 * EDITPAL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dialog.h>
#include <string.h>

extern const char cp_palinfo[];
extern const char *cp_editcolor[];
extern ROBJ *IDD_EditColor;

enum {	ID_OK = 16 + 8, ID_CANCEL };

int edc_putattrib(DOBJ *);

static int palett_event(void)
{
	int x,y,q,result;

	x = tdialog->rc.x;
	y = tdialog->rc.y;
	for (q = 0; q < 16; q++)
		scputf(x + 18, y + 4 + q, 0, 3, "%3d", at_palett[q]);
	result = tdxcellevent();
	mouseoff();
	q = tdialog->index - 8;
	if (result == PGUP) {
		at_palett[q]++;
		setpal(at_palett[q], q);
	} else if (result == PGDN) {
		at_palett[q]--;
		setpal(at_palett[q], q);
	}
	mouseon();
	return result;
}

int editpal(void)
{
	int x,y,q;
	COLOR edc;
	DOBJ *d;

	if ((d = rsopen(IDD_EditColor)) == NULL)
		return 0;
	tdshow(d);
	memcpy(&edc, at_background, 40);
	edc_putattrib(d);
	x = d->rc.x;
	y = d->rc.y + 4;
	for (q = 0; q < 16; q++)
		scputs(x + 46, y + q, 0, 0, cp_editcolor[q]);
	scputs(x +  4, y - 2,  0, 0, cp_palinfo);
	scputs(x + 35, y,      0, 0, cp_editcolor[16]);
	scputs(x + 35, y + 8,  0, 0, cp_editcolor[17]);
	scputs(x + 35, y + 12, 0, 0, cp_editcolor[18]);

	for (q = 0; q < 8; q++)
		d->object[q].flag |= _O_STATE;
	for (q = 8; q < 16 + 8; q++)
		d->object[q].proc = palett_event;
	for (q = 0; q < 16; q++) {
		scputf(x + 5, y + q, 0, 7, "%X   %3d", q, at_palett[q]);
		scputf(x + 18, y + q, at_DialogKey, 3, "%3d", at_palett[q]);
	}
	q = rsevent(IDD_EditColor, d);
	tdclose(d);
	if (q == 0) {
		LoadColor(&edc);
		loadpal(at_palett);
		return 0;
	}
	return 1;
}