/* CRYPT.C--
 * Copyright (c) 1990-2000 Info-ZIP. All rights reserved.
 *
 * Change history:
 * 27 Mar 2005	- modified for DOSZIP
 */

#include <arch.h>
#include <string.h>
#include <tdialog.h>

extern const char cp_enterpassword[];

#define PWLEN		80
#define RAND_HEAD_LEN	12
#define CRC32(c, b)	(crctab[((int)(c) ^ (b)) & 0xff] ^ ((c) >> 8))

static DWORD keys[3];
static char password[PWLEN];

static void wzipinitkeys(char *);
static int  wziptestp(BYTE *);

int wzipdecrypt(void)
{
	int  n;
	WORD b;
	BYTE h[RAND_HEAD_LEN];

	for (n = 0; n < RAND_HEAD_LEN; n++) {
		b = wzipgetbyte();
		h[n] = (BYTE)b;
	}
	if (wziptestp(h) == 0)
		return 1;
	password[0] = 0;
	n = tgetline(cp_enterpassword, password, 32, PWLEN);
	if (n == 0 || password[0] == 0)
		return 0;
	if (wziptestp(h) == 0)
		return 1;
	return 0;
}

int wzipdecryptbyte(void)
{
	WORD temp;

	temp = (WORD)keys[2] | 2;
	return (int)(((WORD)(temp * (temp ^ 1)) >> 8) & 0xff);
}

int wzipupdatekeys(int c)
{
	keys[0] = CRC32(keys[0], c);
	keys[1] += keys[0] & 0xff;
	keys[1] = keys[1] * 134775813L + 1;
	keys[2] = CRC32(keys[2], (int)(keys[1] >> 24));
	return c;
}

static void wzipinitkeys(char *passwd)
{
	keys[0] = 305419896L;
	keys[1] = 591751049L;
	keys[2] = 878082192L;
	while (*passwd != '\0') {
		wzipupdatekeys((int)*passwd);
		passwd++;
	}
}

static int wziptestp(BYTE *h)
{
	WORD b, c;
	int n;
	BYTE *p;
	BYTE hh[RAND_HEAD_LEN];

	wzipinitkeys(password);
	memcpy(hh, h, RAND_HEAD_LEN);
	for (n = 0; n < RAND_HEAD_LEN; n++)
		wzipdecode(hh[n]);
	b = hh[RAND_HEAD_LEN-1];
	c = zip_attrib & _A_EXTLOCHD;
	if (b != (c ? zip_local.time >> 8 : (WORD)(zip_local.crc >> 24)))
		return -1;
	for (n = zip_bsize - 12, p = &zip_inbuf[12]; n--; p++)
		wzipdecode(*p);
	return 0;
}