/* TIME.H--
 * Copyright (c) 2001 Hjort Nidudsson
 *
 * Change history:
 * 20 Mar 2007	- removed strltodw()
 * 14 Sep 2001	- Created
 */
#ifndef __INC_TIME
#define __INC_TIME
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#define DT_DAYCOUNT	365
#define DT_QUADCOUNT	(DT_DAYCOUNT * 4 + 1)

#define DT_WEEKDAY	0
#define DT_BASEYEAR	1980
#define DT_LASTYEAR	2107
#define DT_MAXYEAR	(DT_LASTYEAR - DT_BASEYEAR)
#define DT_BASEDATE	0x0021
#define DT_LASTDATE	0xFF9F

#define dt_isleap(y) 	\
	((((y % 4) == 0) && ((y % 100) != 0)) || ((y % 400) == 0))

#define dt_mkdw(d,m,y)	(d | (m << 5) | ((y - DT_BASEYEAR) << 9))
#define dt_testdw(w)	((w) && ((w) & 0x01E0) && ((w) & 0x01E0) <= 0x0180)

#define dwtoday(w)	((w) & 0x001F)
#define dwtomnd(w)	(((w) >> 5) & 0x000F)
#define dwtoyear(w)	(((w) >> 9) + DT_BASEYEAR)

#define twtosec(w)	(((w) & 0x001F) * 2)
#define twtomin(w)	(((w) >> 5) & 0x003F)
#define twtohour(w)	(((w) >> 11) & 0x001F)

#define DT_SEEKSET    	0
#define DT_SEEKCUR    	1
#define DT_SEEKEND    	2

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct {
	unsigned	sec : 5;
	unsigned	min : 6;
	unsigned	hour: 5;
      } time_t;

typedef struct {
	unsigned	day : 5;
	unsigned	mnd : 4;
	unsigned	year: 7;
      } date_t;

struct dostime_t {
	unsigned char hour;
	unsigned char minute;
	unsigned char second;
	unsigned char hsecond;
};

int  _CType getyear(void);
char _CType getmnd(void);
char _CType getday(void);
char _CType gethour(void);
char _CType getmin(void);
char _CType getsec(void);

int _CType weekdayjan(int __y);
int _CType weekdaymnd(int __m, int __y);
int _CType daysinmnd(int __m, int __y);
int _CType testdate(int __d, int __m, int __y);

WORD _CType twdostime(void);
WORD _CType dwdosdate(void);
WORD _CType dwnextdate(WORD);
WORD _CType dwprevdate(WORD);
WORD _CType dwseekdate(WORD __date, int __offset, int __fromwhere);
WORD _CType dwweekday(WORD);

/* [dd.mm.yy|yyyy] | [mm/dd/yy|yyyy] */
WORD _CType strtodw(const char *__date);
WORD _CType strtotw(const char *__hh_mm_ss);

char *_CType dwtostr(char *, WORD __dw);  /* 'dd.mm.yy'   */
char *_CType dwtolstr(char *, WORD __dw); /* 'dd.mm.yyyy' */
char *_CType twtostr(char *, WORD __tw);  /* 'hh:mm:ss'   */

void _CType _dos_gettime(struct dostime_t *__timep);
void _CType _dos_settime(char __hour, char __min, char __sec);
void _CType _dos_setdate(int __year, char __mnd, char __day);

#ifdef __cplusplus
 }
#endif
#endif