/* IOST.H--
 * Copyright (c) 2008 Hjort Nidudsson
 *
 * Change history:
 * 21 Aug 2008	- Created
 */

#ifndef __INC_IOST
#define __INC_IOST
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#define SEEK_CUR    	1
#define SEEK_END    	2
#define SEEK_SET    	0

#define NSTREAM	        10

#define __STDI		0
#define __STDO		1

#define STDI		_ios[__STDI]
#define STDO		_ios[__STDO]
#define OSTDI		((WORD)&STDI)
#define OSTDO		((WORD)&STDO)

#define ISIZE		0x4000
#define OSIZE		0x8000

#define IO_SEARCHWORD   0x0001	/* Search whole words		*/
#define IO_SEARCHCASE	0x0002	/* Case sensitive search	*/
#define IO_SEARCHHEX    0x0004	/* Search hex string/ascii	*/
#define IO_SEARCHSET	0x0008	/* Search entire scope		*/
#define IO_SEARCHCUR	0x0010	/* Search from cursor/set	*/
#define IO_SEARCHMASK	0x001F
#define IO_LWRD		0x0020	/* DZIP - Last Write is Data	*/
#define IO_LWRC		0x0040	/* DZIP - Last Write is Code	*/
#define IO_LOCK		0x0080	/* DZIP - Stream is Read Only	*/
#define IO_CRYPT	0x0100	/* Crypted file			*/
#define IO_USEUPD	0x0200	/* Progress			*/
#define IO_UPDTOTAL	0x0400	/* Add Read/Write size to total	*/
#define IO_USECRC	0x0800	/* Update CRC on read/write	*/
#define IO_USEBITS	0x1000	/* Align bits on read/write	*/
#define IO_EXTFLUSH	0x2000	/* Extern flush proc		*/
#define IO_MEMREAD	0x4000	/* Read from memory		*/
#define IO_ERROR	0x8000	/* Write fault			*/

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct IOBS {
	unsigned char *	bp;	/* buffer */
	unsigned int 	i;	/* index in buffer */
	unsigned int 	c;      /* byte count */
	unsigned int 	memz;   /* alloc size */
	unsigned int	flag;
	int		file;
	int		l;      /* number of bits in bit buffer */
	unsigned long	bb;     /* bit buffer | CRC value */
	unsigned long	total;  /* total bytes in/out | filesize */
	unsigned long	offs;   /* file offset | loop count */
	int (*flush)(struct IOBS *);
      } IOST;
extern	IOST _CType _ios[];

int _CType oopen(const char *__file, int __mode); /* M_WRONLY | M_RDONLY */
int _CType ioopen(const char *__rdfile, const char *__wrfile);
int _CType oinitst(WORD __offset);
int _CType oinitio(void);
int _CType oclose(WORD __offset);
int _CType ioclose(int __return_code);
int _CType ofreest(WORD __offset);
int _CType ofreeio(void);
int _CType oputb(WORD, int);
int _CType ofread(void);
int _CType ofwrite(void);
int _CType oputc(int);
int _CType ogetc(void);
int _CType ogetb(int);
int _CType oungetc(void);
int _CType oungetx(WORD __x);
int _CType oflush(IOST *);
int _CType ocopy(DWORD);	/* copy count bytes from STDI to STDO */
int _CType sputc(WORD __offset, int);
int _CType sputb(WORD __offset, WORD, int);
int _CType oinitst(WORD __offset);
int _CType ofreest(WORD __offset);
int _CType oinitio(void);
int _CType ofreeio(void);
int _CType odecrypt(void);
int _CType oseek(DWORD, int);
int _CType oseekl(DWORD, int);
char *_CType ogets(int);
int _CType offlush(void);
int _CType owrite(IOST *, void *, WORD __size);
int _CType oread(void *, WORD __size);
int _CType oupdate(int);

extern char searchstring[128];
DWORD _CType osearch(int __h, DWORD __fz, void *__b, int __bz, int __usecase);
void _CType onotfoundmsg(void);
int _CType continue_search(void);
int _CType cmdsearch(DWORD __fsize);
long _CType osearchhex(void);
long _CType osearchtxt(void);

int near _fastcall odecode(int);

#ifdef __cplusplus
 }
#endif
#endif