/* GZIP.H--
 * Copyright (c) 2007 Hjort Nidudsson
 *
 * Change history:
 * 04 Apr 2007	- Created
 */
#ifndef __INC_GZIP
#define __INC_GZIP
#include <defs.h>

#define GZ_HEADERID	0x8B1F		/* two-byte gzip lead-in */
#define GZ_DEFLATED	8

/* gzip flag byte */
#define GZ_ASCII_FLAG   0x01 /* bit 0 set: file probably ascii text */
#define GZ_CONTINUATION 0x02 /* bit 1 set: continuation of multi-part gzip file */
#define GZ_EXTRA_FIELD  0x04 /* bit 2 set: extra field present */
#define GZ_ORIG_NAME    0x08 /* bit 3 set: original file name present */
#define GZ_COMMENT      0x10 /* bit 4 set: file comment present */
#define GZ_ENCRYPTED    0x20 /* bit 5 set: file is encrypted */
#define GZ_RESERVED     0xC0 /* bit 6,7:   reserved */

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct 	{ /* Local file header */
	WORD	magic;
	BYTE	method;
	BYTE	flag;
	DWORD	time;
	BYTE	extra;
	BYTE	OS;
/*     [filename + comment + data] */
	DWORD	crc;
	DWORD	size;
      } GZIP; /* 18 byte */

#ifdef __cplusplus
 }
#endif
#endif