/* DZCONFIG.H--
 * Copyright (c) 2007 Hjort Nidudsson
 *
 * Change history:
 * 07 Mar 2007	- Created
 */
#ifndef __INC_DZCONFIG
#define __INC_DZCONFIG

#include <dir.h>
#include <ini.h>
#include <filter.h>
#include <dzpanel.h>

#define _C_PANELID	0x0001
#define _C_HORIZONTAL	0x0002
#define _C_SMALLPANELS	0x0004
#define _C_EGALINE	0x0008
#define _C_SELECTDIR	0x0010
#define _C_INSMOVDN	0x0020
#define _C_CDCLRDONLY	0x0040
#define _C_AUTOSAVE	0x0080
#define _C_SAVEDZCMD	0x0400
#define _C_DELZIPLST	0x0800

/* Compress flags */

#define _C_ZPACKERID	0x000F	/* from .INI file [Packer]->0?= ? */
#define _C_ZINCDIR	0x0010
#define _C_ZDECOMP	0x0020

#define _C_ZSMALLEST	0x0100	/* M3_MAXIMUM */
#define _C_ZFASTEST	0x0200  /* M1_FAST */
#define _C_ZBEST	0x0300
#define _C_ZAUTOSELECT	0x0000  /* M1_FAST */

#define _C_ZPASSWORD	0x0400

/* Confirm flags */

#define _C_CONFCOPY	0x01
#define _C_CONFMOVE	0x02
#define _C_CONFDELETE	0x04
#define _C_CONFDELSUB	0x08
#define _C_CONFSYSTEM	0x10
#define _C_CONFRDONLY	0x20
#define _C_CONFEXIT	0x40

/* Textview Config */

#define TV_HEXVIEW	0x8000
#define TV_BINVIEW	0x4000
#define TV_WRAPLINES	0x2000
#define TV_HIGHCOLOR	0x1000
#define TV_HEXOFFSET	0x0800

/* Filesearch Config */
#define FSEARCH_WORD	0x0001	/* Search whole words		*/
#define FSEARCH_CASE    0x0002	/* Case sensitive search	*/
#define FSEARCH_HEX     0x0004	/* Search hex string/ascii	*/
#define FSEARCH_SET     0x0008	/* Search entire scope		*/
#define FSEARCH_CUR     0x0010	/* Search from cursor/set	*/
#define FSEARCH_MASK	0x001F	/*				*/
#define FSEARCH_SUB     0x0020
#define FSEARCH_SAVE    0x0040

typedef struct {
	WORD	version;
	WORD	dzflag;
	BYTE	confirm;
	BYTE	console;
	WORD	dxflag;
	WORD	compress;
	WORD 	idb[MAXPANELS];
	WORD 	idx[MAXPANELS];
	PATH	ide[MAXPANELS];
	FILT 	opfilt;
	COLOR	dzcolor;
	char	pending_file[WMAXPATH];
      } DZCFG;
extern	DZCFG 	config;
#define cflag	config.dzflag
#define zflag	config.compress
#define xflag	config.dxflag
#define aflag	config.ide[0].flag
#define bflag	config.ide[1].flag

int config_init(void);
int config_read(void);
int config_write(void);
int create_INI(void);

extern char default_ini[];
extern const char cp_dzcmd[];
extern const char cp_ziplst[];

#endif