/* DEFS.H--
 * Copyright (c) 1996 Hjort Nidudsson
 *
 * Change history:
 * 28 Oct 2008	- added version.h
 * 18 Oct 1996	- Created
 */
#ifndef __INC_DEFS
#define __INC_DEFS

#include <version.h>

#if !defined(__BORLANDC__) && !defined(__TURBOC__)
 #error: Not ready to be used on other than Borland C/C++ or Turbo C/C++ compilers!
#endif

#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
 #define LDATA 1
#else
 #define LDATA 0
#endif
#if defined(__LARGE__) || defined(__HUGE__) || defined(__MEDIUM__)
 #define LPROG 1
#else
 #define LPROG 0
#endif

#if !defined(__LARGE__)
 #error You must use large memory model..
#endif

#ifndef __PASCAL__
// #define CTYPE _cdecl
 #error Calling Convention Pascal must be set..
#else
 #define CTYPE _pascal
#endif
#define _CType	CTYPE

#define _FAR
#define _FARFUNC
#define NULL  	0L

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef DEBUG
 #define _ASSERT(exp)  ((void)0)
 #define _ASSERTE(exp) ((void)0)
#else
 void _CType debug(char *, int, char *, int);
 #define _ASSERT(exp)\
    do { if (exp) debug(__FILE__, __LINE__, #exp, 0); } while(0)
 #define _ASSERTE(exp)\
    do { if (exp) debug(__FILE__, __LINE__, #exp, 1); } while(0)
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

typedef unsigned char	BYTE;
typedef unsigned int 	WORD;
typedef unsigned long 	DWORD;

#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define INRANGE(x,s,e)	(((x) >= (s)) && ((x) <= (e)))
#define TOUPPER(c)	((c) & 0xDF)
#define TOLOWER(c)	((c) | 0x20)
#define MKW(hb,lb)  	((WORD)(((BYTE)hb<<8)|((BYTE)lb)))
#define DIVK(x)		((x)>>(10))
#define DIVM(x)		((x)>>(20))

#ifdef __cplusplus
 }
#endif
#endif /* __INC_DEFS */