; ARCH.INC
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		iost.inc
INCLUDE		wsub.inc

; The return codes
;NO_ERROR	= 0
ER_WARN		= 1
ER_ZIP		= 2
ER_BADERR	= 3
ER_MEM		= 4
ER_CRCERR	= 5
ER_NOZIP	= 9	; archive not found
ER_PARAM	= 10
ER_FIND		= 11	; no files found
ER_OPEN		= 12	; error open temp file or source file
ER_DISK		= 50	; output space exhausted before completing
ER_EOF		= 51	; unexpected EOF
ER_USERABORT	= 66    ; User abort - ESC --> continue/cancel
ER_READARCH	= -2	; Returned from wsread() functions

arc_srchnd	=	[_ios.ios_file]
arc_outhnd	=	[_ios.ios_file + SIZE IOST_S]

ARCMAXFNAME	= 512

ZIPHEADERID	= 4B50h		; two-byte zip lead-in
ZID_LOCAL	= 04034B50h	; signature local file
ZID_CENTRAL	= 02014B50h	; signature central file
ZID_DIGITAL	= 05054b50h	; digital signature
ZID_ENDSENTR	= 06054b50h	; signature end central

ZM_STORED	= 0		; compression methods
ZM_IMPLODED	= 6
ZM_DEFLATED	= 8

lzip		STRUC
		lz_signature	DD ?
		lz_version	DW ?
		lz_flag		DW ?
		lz_method	DW ?
		lz_time		DW ?
		lz_date		DW ?
		lz_crc		DD ?
		lz_csize	DD ?
		lz_fsize	DD ?
		lz_namelen	DW ?
		lz_extlen	DW ?
		ENDS

GLOBAL PASCAL 	zip_local:	lzip
GLOBAL PASCAL 	wzipinflate:	DIST
GLOBAL PASCAL 	wzipexplode:	DIST

GLOBAL PASCAL	crctab:		DWORD:[256]
GLOBAL PASCAL 	entryname:	BYTE:[ARCMAXFNAME]
GLOBAL PASCAL 	__outpath:	BYTE:[WMAXPATH]
GLOBAL PASCAL 	__srcpath:	BYTE:[WMAXPATH]
GLOBAL PASCAL 	__outfile:	BYTE:[WMAXPATH]
GLOBAL PASCAL 	__srcfile:	BYTE:[WMAXPATH]

_CPYSELECTED	= 0001h		; copy_flag
_CPYRECURSIV	= 0002h
_CPYOUTZIP	= 0004h
_CPYOUTDZIP	= 0008h
_CPYSRCARCH	= 0010h
_CPYPATHEQU	= 0020h
_CPYOUTARCH	= (_CPYOUTZIP or _CPYOUTDZIP)

GLOBAL PASCAL	copy_flag:	WORD
GLOBAL PASCAL	copyfile:	DIST
GLOBAL PASCAL	wzipadd:	DIST
GLOBAL PASCAL	dzipadd:	DIST

GLOBAL PASCAL 	arc_maketemp:	DIST	; compile temp name
GLOBAL PASCAL 	arc_opentemp:	DIST	; uses __outfile + ARCTEMP
GLOBAL PASCAL 	arc_renametemp:	DIST
GLOBAL PASCAL 	arc_deltemp:	DIST
GLOBAL PASCAL 	unixtodos:	DIST
GLOBAL PASCAL 	dostounix:	DIST
GLOBAL PASCAL 	testentryname:	DIST
GLOBAL PASCAL 	copyhndl:	DIST
GLOBAL PASCAL 	arc_copyhndl:	DIST
GLOBAL PASCAL 	getouthandle:	DIST
GLOBAL PASCAL 	openfile:	DIST
GLOBAL PASCAL 	confirmflag:	WORD
GLOBAL PASCAL 	confirm_delete:	DIST
GLOBAL PASCAL 	confirm_delete_file: DIST
GLOBAL PASCAL 	confirm_delete_sub: DIST
GLOBAL PASCAL 	confirm_continue: DIST
