/* ARCH.H--
 * Copyright (c) 2004 Hjort Nidudsson
 *
 * Change history:
 * 17 Mar 2007	- added _ER_USERABORT
 * 04 Apr 2004	- Created
 */
#ifndef __INC_ARCH
#define __INC_ARCH

#include <wsub.h>
#include <arj.h>
#include <zip.h>
#include <gzip.h>
#include <dzip.h>

#define ARCMAXFNAME	512
#define ARCTEMP_EXT	".$$$"

#define _ER_OK		0
#define _ER_WARN	1
#define _ER_ERRZIP	2
#define _ER_BADERR	3
#define _ER_MEM		4
#define _ER_CRCERR	5
#define _ER_NOZIP	9
#define _ER_FIND	11
#define _ER_DISKFULL	50
#define _ER_EOF		51
#define _ER_USERABORT	66

#define ARCHIVE_ERROR	(-2)

#define _CPYSELECTED	0x0001  /* copy_flag */
#define _CPYRECURSIV	0x0002
#define _CPYOUTZIP	0x0004
#define _CPYOUTDZIP	0x0008
#define _CPYSRCARCH	0x0010
#define _CPYPATHEQU	0x0020
#define _CPYOUTARCH	(_CPYOUTZIP | _CPYOUTDZIP)

#define CFREADONY	0x0001
#define CFSYSTEM	0x0002
#define CFDIRECTORY	0x0004
#define CFSELECTED	0x0008
#define CFDELETEALL	0x0010

#define MSG_DELSINGEL	 1
#define MSG_DELRDONLY	-1
#define MSG_DELSYSTEM	-2

#ifdef __cplusplus
 extern "C" {
#endif

#define arc_srchnd	_ios[__STDI].file
#define arc_outhnd      _ios[__STDO].file

extern char _CType __outpath[WMAXPATH];
extern char _CType __srcpath[WMAXPATH];
extern char _CType __outfile[WMAXPATH];
extern char _CType __srcfile[WMAXPATH];
extern char _CType __arctemp[WMAXPATH];
extern char _CType entryname[ARCMAXFNAME];

char * _CType unixtodos(char *);
char * _CType dostounix(char *);

char * _CType arc_maketemp(char *); /* compile temp name */
int _CType arc_opentemp(void);      /* uses __outfile + ARCTEMP */
int _CType arc_renametemp(void);
int _CType arc_deltemp(void);

int _CType copyhndl(int __ih, int __oh, DWORD __size);
int _CType arc_copyhndl(int __ih, int __oh, DWORD __size);
int _CType getouthandle(const char *);
int _CType openfile(const char *, int __mode, int __action);
int _CType openarch(const char *__path, const char *__file);

extern int _CType confirmflag;
int _CType confirm_delete(const char *, int __selected);
int _CType confirm_delete_file(const char *, const char __attrib);
int _CType confirm_delete_sub(const char *);
int _CType confirm_continue(const char *);

#ifdef __cplusplus
 }
#endif
#endif /* __INC_ARCH */