/* _DTYPES.H--
 * Copyright (c) 2004 Hjort Nidudsson
 *
 * Change history:
 * 04 Apr 2004	- Created
 */
#ifndef __INC__DTYPES
#define __INC__DTYPES
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#define _D_DOPEN	0x0001
#define _D_ONSCR	0x0002
#define _D_DMOVE	0x0004
#define _D_SHADE	0x0008
#define _D_MYBUF	0x0010
#define _D_RCNEW	0x0020
#define _D_RESRC	0x0030
#define _D_BACKG	0x0040
#define _D_FOREG	0x0080
#define _D_CLEAR	0x0100
#define _D_THELP	0x0200
#define _D_RESAT	0x0400
#define _D_LLIST	0x0800
#define _D_STERR	0x1000
#define _D_MENUS	0x2000
#define _D_MUSER	0x4000

#define _D_COLOR	0x00C0
#define _D_STDLG	0x0000
#define _D_ALLOC	0x0000

#define _D_RCSAVE	0xFC0C
#define _D_STDDLG	(_D_DMOVE|_D_SHADE|_D_CLEAR|_D_COLOR)
#define _D_STDERR	(_D_STDDLG|_D_STERR)

#define O_type(o)	(o->flag & 0x000F)
#define O_clrtype(o)	(o->flag &= 0xFFF0)
#define O_settype(o,t)	(o->flag |= t)

#define _O_PBUTT	0
#define _O_RBUTT	1
#define _O_CHBOX	2
#define _O_XCELL	3
#define _O_TEDIT	4
#define _O_MENUS	5
#define _O_XHTML	6
#define _O_MOUSE	7
#define _O_LLMSU	8
#define _O_LLMSD	9

#define _O_FLAGA	0x0010
#define _O_FLAGB	0x0020
#define _O_LLIST	0x0040
#define _O_RADIO	0x0100
#define _O_DEXIT	0x0200
#define _O_DHELP	0x0400
#define _O_CURID	0x0800

#define _O_GLCMD	0x1000
#define _O_EVENT	0x2000
#define _O_CHILD	0x4000
#define _O_STATE	0x8000
#define _O_DEACT	_O_STATE

#define _C_NORMAL	1
#define _C_RETURN	2
#define _C_ESCAPE	3
#define _C_REOPEN	4

#define CURSOR_NORMAL	0x0607
#define CURSOR_HIDDEN	0x0F00

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct {
	BYTE	ch;
	BYTE	at;
      } WCHR;

typedef struct {
	BYTE	x;
	BYTE	y;
	BYTE	col;
	BYTE	row;
      } RECT;

typedef struct {
	WORD	flag;
	BYTE	xpos;
	BYTE	ypos;
      } COBJ;

typedef struct {
	WORD	flag;
	BYTE	count;
	BYTE	ascii;
	RECT	rc;
      } FOBJ;

typedef struct {
	WORD	flag;
	BYTE	count;
	BYTE	ascii;
	RECT	rc;
	void *	data;
	int (*	proc)(void);
      } TOBJ;

typedef struct {
	WORD	flag;
	WORD	key;
	RECT	rc;
	void *	data;
	int (*	proc)(void);
      } MOBJ;

typedef struct {
	WORD	flag;
	BYTE	count;
	BYTE	index;
	RECT	rc;
	WCHR *	wp;
	TOBJ *	object;
      } DOBJ;

typedef struct {
	WORD	memsize;
	FOBJ	dialog;
	FOBJ	object[1];
      } ROBJ;

typedef struct {
	WORD	key;
	int (*	proc)(void);
      } GCMD;

typedef struct {
	WORD	dlgoff;
	WORD	dcount;
	WORD	celoff;
	WORD	numcel;
	WORD	count;
	WORD	index;
	void **	list;
	int (*	proc)(void);
      } LOBJ;

#ifdef __cplusplus
 }
#endif
#endif /* __INC__DTYPES */