;
; PROCESS.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		dzmain.inc
INCLUDE		io.inc
INCLUDE		dos.inc
INCLUDE		string.inc
INCLUDE		dialog.inc
INCLUDE		errno.inc

GLOBAL PASCAL	inientry: DIST

IFDEF DEBUG
 INCLUDE	stdio.inc
ENDIF

		Locals

GLOBAL PASCAL	searchp: DIST

_DATA		SEGMENT

		PUBLIC	cp_dzcmd
		GLOBAL	searchstring: BYTE

macro_view  	DB	'%VIEW%',0
macro_edit  	DB 	'%EDIT%',0
macro_find  	DB 	'%FIND%',0
macro_doszip	DB 	'%DOSZIP%',0

format_0	DB	'%s',10,10,'%s',10,10,'%s',0
cp_msg1		DB	"Unable to execute command",0
cp_msg2		DB	"Error: DZ.EXE not loaded.",0
cp_cmdswitch	DB	'/C ',0

cp_dzcmd	DB	'dzcmd.bat',0
cp_echooff	DB	'@echo off'
cp_linefeed	DB	13,10
sz_echooff	=	$ - cp_echooff

cp_initype	DB	'Filetype',0

_DATA		ENDS

_TEXT		SEGMENT

;;; Test if filetype is executable

cmpext:		cmp	eax,' tab'
		je	SHORT @@bat
		cmp	eax,' moc'
		je	SHORT @@com
		cmp	eax,' exe'
		je	SHORT @@exe
		mov	ax,0
		ret
@@bat:		mov	ax,FTYPE_BAT
		ret
@@com:		mov	ax,FTYPE_COM
		ret
@@exe:		mov	ax,FTYPE_EXE
		ret

;;; translate %DOSZIP% to path-string

ex_macrodoszip:	push	cmd
		push	DS
		push	OFFSET macro_doszip
		push	DS
		push	OFFSET programpath
		push	8
		call	ex_addmacro
		ret

ex_initmacro:   call	ex_macrodoszip

;;; test if %VIEW% is in command-string

		push	cmd
		push	DS
		push	OFFSET macro_view
		push	6
		call	strnicmp
		or	ax,ax
		jnz	SHORT @@edit
		lea	dx,cbuf
		add	dx,7
		push	SS
		push	dx
		push	ax
		call	load_tview
		xor	ax,ax
		ret

;;; test if %EDIT% is in command-string

@@edit:		push	cmd
		push	DS
		push	OFFSET macro_edit
		push	6
		call	strnicmp
		or	ax,ax
		jnz	SHORT @@find
		lea	ax,cbuf
		add	ax,7
		push	SS
		push	ax
		push	4
		call	load_tedit
		xor	ax,ax
		ret

;;; test if %FIND% is in command-string

@@find:		push	cmd
		push	DS
		push	OFFSET macro_find
		push	6
		call	strnicmp
		or	ax,ax
		jz	SHORT @@
		ret
@@:		lea	ax,cbuf
		add	ax,7
		push	SS
		push	ax
		push	SS
		push	ax
		push	' '
		call	strchr
		or	ax,ax
		jz	SHORT @@ff
		mov	bx,ax
		xor	ax,ax
		mov	SS:[bx],al
		inc	bx
		push	DS
		push	OFFSET searchstring
		push	SS
		push	bx
		call	strcpy
@@ff:		call	FindFile
		xor	ax,ax
		ret

EXEC_COMSPEC:	lea	ax,exec
		push	SS
		push	ax
		push	comspec
		push	80
		push	SS
		add	ax,(exec_command + 3)
		push	ax
		push	cmd
		push	(128-3)
		push	SS
		sub	ax,3
		push	ax
		push	DS
		push	OFFSET cp_cmdswitch
		call	strcpy
		call	strncpy
		call	strncpy
		ret

EX_INITBLOCK:	lea	bx,exec
		xor	ax,ax
		mov	SS:[bx.exec_argc],al
		mov	SS:[bx.exec_argv],13
		cmp	SS:[bx.exec_command],al
		je	SHORT @@toend
		add	bx,exec_command
		push	SS
		push	bx
		call	strlen
		inc	ax
		lea	bx,exec
		mov	SS:[bx.exec_argc],al
		mov	SS:[bx.exec_argv],' '
@@toend:	ret

EX_COPYBLOCK:	push	dzexe
		push	SS
		lea	ax,exec
		push	ax
		push	SIZE EXECS
		call	memcpy
		mov	ax,1
		mov	_end,ax
		mov	dzexitcode,23
		ret

EX_LOADBLOCK:	lea	bx,exec
		mov	al,SS:[bx.exec_name.1]
		cmp	al,':'
		je	SHORT @@init
		cmp	al,'\'
		je	SHORT @@init
		lea	bx,path
		push	SS
		push	bx
		les     bx,cpanel
		les	bx,ES:[bx.pn_wsub]
		push	ES:[bx.ws_path]
		push    SS
		lea	ax,exec
		push	ax
		call	strfcat
		mov	bx,ax
		mov	BYTE PTR SS:[bx+79],0
		push    SS
		lea	ax,exec
		push	ax
		push	SS
		push	bx
		call	strcpy
@@init:		call	EX_INITBLOCK
		call	EX_COPYBLOCK
		ret

EX_MAKEBATCH:	mov	dx,SS
		lea	ax,path
		push	dx
		push	ax
		push	0
		push	M_WRONLY
		push	(A_CREATE or A_TRUNC)
		push	dx
		push	ax
		push	envtemp
		push	DS
		push	OFFSET cp_dzcmd
		call	strfcat
		call	osopen
		cmp	ax,-1
		je	SHORT @@null
		or	config.c_lflag,_C_DELBATCH
		push	ax
		push	ax
		push	DS
		push	OFFSET cp_echooff
		push	sz_echooff
		call	oswrite
		cmp	ax,sz_echooff
		jne	SHORT @@close
		push	cmd
		call	strlen
		pop	dx
		push	dx
		push	dx
		push	cmd
		push	ax
		call	oswrite
		or	ax,ax
		jz	SHORT @@close
		pop	ax
		push	ax
		push	ax
		push	DS
		push	OFFSET cp_linefeed
		push	2
		call	oswrite
		cmp	ax,2
		jne	SHORT @@close
		call	close
		mov	ax,1
		lea	dx,path
		jmp	SHORT @@toend
@@close:	call	close
@@null:		push	SS
		lea	ax,path
		push	ax
		push	EMERRNO
		push	0
		call	stderror
@@toend:	ret

DZEXE_ERROR:	push	DS
		push	OFFSET cp_msg2
		push	cmd
		push	DS
		push	OFFSET cp_msg1
		push	DS
		push	OFFSET format_0
		push	large 0
		call	ermsg
		add	sp,20
		xor	ax,ax
		ret

EX_LOADBATCH:	call	EX_MAKEBATCH
		or	ax,ax
		jz	SHORT @@toend
		lea	ax,exec
		add	ax,(exec_command + 3)
		push	SS
		push	ax
		push	SS
		push	dx
		call	strcpy
		push	dx
		push	ax
		call	strlen
		add	ax,4
		lea	bx,exec
		mov	SS:[bx.exec_argc],al
		mov	SS:[bx.exec_argv],' '
		call	EX_COPYBLOCK
@@toend:	ret

_TEXT		ENDS

LPROC		ex_getenval
USES		di,si
ARG             vbuff:	DWORD,\
		vname:	DWORD
		mov	ES,envseg
		push	DS
		lds	si,vname
		xor	ax,ax
		mov	bl,[si]
		or	bl,20h
		mov	di,ax
		mov	cx,7FFFh
		cld
@@envloop:      mov	ah,ES:[di]
		or	ah,20h
		cmp	ah,bl
		je	SHORT @@teststr
@@nextenv:	repnz	scasb
		jcxz	SHORT @@not_found
		cmp	ES:[di],al
		jne	SHORT @@envloop
		jmp	SHORT @@not_found
@@teststr:	mov	bx,si
		mov	dx,di
@@next:		lodsb
		or	al,al
		jz	SHORT @@match
		cmp	al,'%'
		jz	SHORT @@match
		mov	ah,ES:[di]
		or	ax,2020h
		inc	di
		cmp	ah,al
		jz	SHORT @@next
		mov	si,bx
		mov	di,dx
		xor	ax,ax
		mov	bl,[si]
		or	bl,20h
		jmp	SHORT @@nextenv
@@match:        cmp     BYTE PTR ES:[di],'='
		jne	SHORT @@nextenv
		inc	di
		lds	si,vbuff
@@strcpy:      	mov	al,ES:[di]
		mov	[si],al
		or	al,al
		jz	SHORT @@endcopy
		inc	si
		inc	di
		jmp	SHORT @@strcpy
@@endcopy:	mov	ax,WORD PTR [vbuff]
		mov	dx,WORD PTR [vbuff+2]
		jmp	SHORT @@found
@@not_found:	xor	ax,ax
		mov	dx,ax
@@found:	pop	DS
		ret
PEND		ex_getenval

LPROC		ex_environ
USES		di,si
ARG		@@arg:	DWORD
LOCAL		mac:	BYTE:[128],\
		val:	BYTE:[WMAXPATH],\
		@@cmd:	DWORD
		mov	eax,@@arg
		mov	@@cmd,eax
@@loop:		push	@@cmd
		push	'%'
		call	strchr
		or	ax,ax
		jz	SHORT @@toend
		mov	si,ax
		inc	ax
		push	dx
		push	ax
		push	'%'
		call	strchr
		or	ax,ax
		jz	SHORT @@toend
		mov	di,ax
		sub	ax,si
		inc	ax
		lea	bx,mac
		push	SS
		push	bx
		push	dx
		push	si
		push	ax
		call	strncpy
		lea	bx,val
		push	SS
		push	bx
		push	dx
		inc	ax
		push	ax
		call	ex_getenval
		or	ax,ax
		jz	SHORT @@reset
		push	@@arg
		lea	ax,mac
		push	SS
		push	ax
		lea	ax,val
		push	SS
		push	ax
		mov	ax,di
		sub	ax,si
		inc	ax
		push	ax
		call	ex_addmacro
		lea	ax,val
		push	SS
		push	ax
		call	strlen
		add	ax,si
		dec	ax
		mov	di,ax
@@reset:	inc	di
		mov	WORD PTR @@cmd,di
		jmp	SHORT @@loop
@@toend:	ret
PEND		ex_environ

PPROC		ex_addmacro
USES		di
ARG		cmdl:	DWORD,\
		macr:	DWORD,\
		string:	DWORD,\
		mlen:	WORD
LOCAL		buf:	BYTE:[320]
@@loop:		push	cmdl
		push	macr
		call	strstr
		or	ax,ax
		jz	SHORT @@toend
		mov	ES,dx
		mov	di,ax
		mov	BYTE PTR ES:[di],0
		add	di,mlen
		push	SS
		lea	ax,buf
		push	ax
		push	SS
		push	ax
		push	SS
		push	ax
		push	cmdl
		call	strcpy
		push	string
		call	strcat
		push	WORD PTR [cmdl+2]
		push	di
		call	strcat
		push	cmdl
		push	dx
		push	ax
		add	ax,(WMAXPATH-1)
		mov	bx,ax
		mov	BYTE PTR SS:[bx],0
		call	strcpy
		jmp	SHORT @@loop
@@toend:	ret
PEND		ex_addmacro

PPROC		ex_command
USES		si
ARG		cmd:	DWORD
LOCAL		exec:	BYTE:[SIZE EXECS],\
		cbuf:	BYTE:[WMAXPATH],\
		path:	BYTE:[WMAXPATH],\
		exep:	DWORD,\
		argp:	DWORD
		push	cmd
		call	strtrim
		or	ax,ax
		jz	SHORT @@toend
		lea	ax,cbuf
		push	SS
		push	ax
		push	cmd
		push	WMAXPATH
		call	strncpy
		mov	WORD PTR [cmd],ax
		mov	WORD PTR [cmd+2],dx
		push	dx
		push	ax
		call	ex_environ
		call	ex_initmacro
		jz	SHORT @@toend
IFDEF DEBUG
		mov	WORD PTR dzexe,OFFSET _bufin
		mov	WORD PTR dzexe+2,DS
		jmp	SHORT @@load
ELSE
		xor	eax,eax
		cmp	eax,dzexe
		jnz	SHORT @@load
		call	DZEXE_ERROR
		jmp	SHORT @@toend
ENDIF

@@command:	call	EXEC_COMSPEC
@@loadexe:	call	EX_LOADBLOCK
		jmp	SHORT @@toend
@@batch:        call	EXEC_COMSPEC
		call	EX_LOADBATCH
@@toend:	ret

@@load:		push	cmd
		push	10
		call	strchr
		or	ax,ax
		jnz	SHORT @@batch

		push	cmd
		push	'>'
		call	strchr
		or	ax,ax
		jnz	SHORT @@command
		push	cmd
		push	'<'
		call	strchr
		or	ax,ax
		jnz	SHORT @@command
		push	cmd
		push	' '
		call	strchr
		or	ax,ax
		jz	SHORT @@load_1
		mov	bx,ax
		mov	BYTE PTR ES:[bx],0
@@load_1:	mov	WORD PTR argp,ax
		mov	WORD PTR argp+2,dx
		lea	ax,exec
		mov	WORD PTR exep,ax
		mov	WORD PTR exep+2,SS
		push	exep
		push	cmd
		call	strcpy
		cmp	argp,0
		jz	SHORT @@load_2
		les	bx,argp
		mov	BYTE PTR ES:[bx],' '
@@load_2:	push	exep
		call	searchp
		or	ax,ax
		jnz	SHORT @@load_3
		jmp	@@command
@@load_3:	push	exep
		push	dx
		push	ax
		call	strcpy
		push	exep
		call	isexec
		cmp	ax,FTYPE_EXE
		je	SHORT @@exe
@@com:		jmp	@@command
@@exe:		les	bx,argp
		or	bx,bx
		jz	SHORT @@noargs
		inc	bx
		mov	ax,ES
		les	dx,exep
		add	dx,exec_command
		push	ES
		push	dx
		push	ax
		push	bx
		push	126
		call	strncpy
		jmp	SHORT @@args
@@noargs:	xor	ax,ax
		les	bx,exep
		mov	ES:[bx.exec_command],al
@@args:		cmp	_ifsmgr,0
		jz	SHORT @@ldexe
		cmp	_osmajor,5
		jne	SHORT @@ldexe
		push	SS
		lea	ax,exec
		push	ax
		push	0
		push	M_RDONLY
		push	A_OPEN
		call	osopen
		cmp	ax,-1
		je	SHORT @@com
		push	ax
		push	ax
		push	SS
		lea	ax,path
		push	ax
		push    SIZE EXES
		call	osread
		pop	dx
		push	ax
		push	dx
		call	close
		pop	ax
		cmp	ax,SIZE EXES
		jne	SHORT @@com
		lea	bx,path
		cmp	SS:[bx.exe_offset_relocation],0040h
		jb	SHORT @@ldexe
		cmp	SS:[bx.exe_initial_CSIP],00000000h
		je	SHORT @@com
@@ldexe:	jmp	@@loadexe
PEND		ex_command

PPROC		ex_convert
USES		si
ARG		cmd:	DWORD
		push	cmd
		call	ex_environ
		call	ex_macrodoszip
		mov	ax,WORD PTR cmd
		mov	dx,WORD PTR cmd+2
		ret
PEND		ex_convert

PPROC		isexec
ARG		@@fn:	DWORD
		push	@@fn
		push	'.'
		call	strrchr
		or	ax,ax
		jz	SHORT @@toend
		mov	ES,dx
		mov	bx,ax
		mov	eax,ES:[bx+1]
		or	eax,20202020h
		call	cmpext
@@toend:	ret
PEND		isexec

PPROC		parsecmd
ARG		@@bp:	DWORD,\
		@@line:	DWORD,\
		@@file:	DWORD,\
		@@ext:	DWORD
LOCAL		@@si:	DWORD,\
		@@di:	DWORD
USES		si,di
		lea	si,@@si
		lea	di,@@di
		push	@@bp
		push	@@line
		call	strcpy
		push	@@line
		push	'!'
		call	strchr
		or	ax,ax
		jnz	SHORT @@convert
		push	@@bp
		mov	@@si,' '
		push	SS
		push	si
		call	strcat
		push	@@bp
		push	@@file
		call	strcat
@@toend:        mov	@@si,' ,'
		mov	@@di,0D0Ah
		push	@@bp
		push	SS
		push	si
		push	SS
		push	di
		push	2
		call	ex_addmacro
		push	@@bp
		call	ex_command
		ret
@@convert:	mov	@@si,'!!'
		mov	@@di,''
		push	@@bp
		push	SS
		push	si
		push	SS
		push	di
		push	2
		call	ex_addmacro
		cmp	@@ext,0
		jz	SHORT @@noext
		mov	@@si,'!.'
		push	@@bp
		push	SS
		push	si
		push	@@ext
		push	2
		call	ex_addmacro
		les	bx,@@ext
		mov	BYTE PTR ES:[bx],0
		mov	@@si,'!'
		push	@@bp
		push	SS
		push	si
		push	@@file
		push	1
		call	ex_addmacro
		les	bx,@@ext
		mov	BYTE PTR ES:[bx],'.'
		jmp	SHORT @@endext
@@noext:	mov	@@si,'.!'
		mov	@@di,0
		push	@@bp
		push	SS
		push	si
		push	SS
		push	di
		push	2
		call	ex_addmacro
		mov	@@si,'!'
		push	@@bp
		push	SS
		push	si
		push	@@file
		push	1
		call	ex_addmacro
@@endext:	mov	@@si,''
		mov	@@di,'!'
		push	@@bp
		push	SS
		push	si
		push	SS
		push	di
		push	2
		call	ex_addmacro
		jmp	@@toend
PEND		parsecmd

PPROC		fbinitype
ARG		@@fb:	DWORD,\
		@@bp:	DWORD
LOCAL		@@ext:	DWORD,\
		@@p:	DWORD
USES		si
		xor	si,si
		les	ax,@@fb
		add	ax,fb_name
		push	ES
		push	ax
		push	'.'
		call	strrchr
		or	ax,ax
		jz	SHORT @@noext
		mov	WORD PTR @@ext,ax
		mov	WORD PTR @@ext+2,dx
		push	DS
		push	OFFSET cp_initype
		push	dx
		inc	ax
		push	ax
		call	inientry
		or	ax,ax
		jz	SHORT @@noext
		push	@@bp
		push	dx
		push	ax
		mov	eax,@@fb
		add	ax,fb_name
		push	eax
		push	@@ext
		call	parsecmd
		mov	si,1
@@noext:        or	si,si
		jnz	SHORT @@toend
		push	DS
		push	OFFSET cp_initype
		mov	eax,@@fb
		add	ax,fb_name
		push	eax
		call	inientry
		or	ax,ax
		jz	SHORT @@toend
		push	@@bp
		push	dx
		push	ax
		mov	eax,@@fb
		add	ax,fb_name
		push	eax
		push	large 0
		call	parsecmd
		mov	si,1
@@toend:	mov	ax,si
		ret
PEND		fbinitype

		END
