/*
 * WZIPADD.C - Add files and directories to .ZIP archive
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <alloc.h>
#include <string.h>
#include <arch.h>
#include <errno.h>
#include <progress.h>

extern char cp_arctempfile[]; /* [.ZIP tempfile] */

void ercopyhndl(void);

int arc_copyhndl(int ih, int oh, DWORD size)
{
	zip_crcval = 0xFFFFFFFFL;
	if (copyhndl(ih, oh, size) == 0) {
		ercopyhndl();
		return 0;
	}
	return 1;
}

int wzipcopylocal(int zh, int oh, LZIP *z)
{
	if (wzipwritelocal(oh, z) == 0)
		return 0;
	if (z->csize + z->extsize) {
		if (copyhndl(zh, oh, z->csize + z->extsize) == 0)
			return 0;
	}
	return 1;
}

int wzipcopycentral(int zh, int oh, CZIP *z)
{
	if (wzipwritecentral(oh, z) == 0)
		return 0;
	if (z->extsize + z->cmtsize) {
		if (copyhndl(zh, oh, z->extsize + z->cmtsize) == 0)
			return 0;
	}
	return 1;
}

char *wzipmkpath(char *b)
{
	if (__outpath[0]) {
		strcpy(b, __outpath);
		strcat(b, "/");
		strcat(b, strfn(__srcfile));
	} else {
		strcpy(b, strfn(__srcfile));
	}
	return b;
}

int wzipopenfiles(void)
{
	if ((arc_srchnd = osopen(__outfile, _A_NORMAL, M_RDONLY, A_OPEN)) == -1)
		return stderror(__outfile, EMEROPEN, 0);
	if ((arc_outhnd = arc_opentemp()) == -1) {
		close(arc_srchnd);
		return stderror(cp_arctempfile, EMEROPEN, 0);
	}
	return 1;
}

int wzipffindlocal(long size)
{
	int sh,oh,sl,result;
	char b[WMAXPATH];
	long ol,fz;
	LZIP zl;

	if (wzipopenfiles() == 0)
		return -1;
	ol = 0L;
	result = 0;
	sh = arc_srchnd;
	oh = arc_outhnd;
	wzipmkpath(b);
	sl = strlen(b);
	progress_set(__srcfile, __outfile, MAX(size, filelength(sh)));
	progress_size += (progress_size >> 6);
	while (wzipreadlocal(sh, &zl, 0)) {
		fz = sizeof(LZIP) + zl.fnsize + zl.extsize + zl.csize;
		if (sl == zl.fnsize && strnicmp(b, entryname, sl) == 0) {
			_ASSERTE(result == 1);
			memcpy(&zip_local, &zl, sizeof(LZIP));
			zip_local.crc = ol;
			zip_local.csize = fz;
			result = 1;
			if (zl.extsize + zl.csize)
				lseek(sh, zl.extsize + zl.csize, SEEK_CUR);
		} else {
			if (wzipcopylocal(sh, oh, &zl) == 0)
				break;
			progress_update(ol);
			ol += fz;
		}
	}
	if (zl.signature != ZID_CENTRAL) {
		close(arc_outhnd);
		close(arc_srchnd);
		arc_deltemp();
		return stderror(__outfile, EMARCHIVE, -1);
	}
	zip_local.fsize = ol;
	return result;
}

int wzipadd(long size, int date, int time, char attrib)
{
	int sh,oh,fh,x;
	char b[WMAXPATH];
	LZIP zl;
	CZIP zf;
	ZCEN zc;
	DWORD ol;
	DWORD of;
	DWORD ex;

	x = wzipffindlocal(size);
	if (x == -1)
		return -1;
	if (x == 1)
		ol = zip_local.crc;
	else
		ol = 0xFFFFFFFFL;
	sh = arc_srchnd;
	oh = arc_outhnd;
	if (size) {
		if ((fh = osopen(__srcfile, _A_NORMAL, M_RDONLY, A_OPEN)) == -1) {
			close(sh);
			close(oh);
			arc_deltemp();
			return stderror(__srcfile, EMEROPEN, -1);
		}
	}
	wzipmkpath(b);
	zl.signature 	= ZID_LOCAL;
	zl.version 	= 20;
	zl.flag 	= 0;
	zl.method 	= 0;
	zl.time 	= time;
	zl.date 	= date;
	zl.crc 		= 0;
	zl.csize 	= size;
	zl.fsize 	= size;
	zl.fnsize 	= strlen(b);
	zl.extsize 	= 0;
	of = zip_local.fsize;
	oswrite(oh, &zl, sizeof(LZIP));
	oswrite(oh, b, zl.fnsize);
	if (size) {
		if (size > progress_size)
			progress_size += size;
		x = arc_copyhndl(fh, oh, size);
		close(fh);
		if (x == 0) {
			close(sh);
			close(oh);
			arc_deltemp();
			return stderror(__outfile, EMARCHIVE, -1);
		}
	}
	zc.offset_sd = of + size + zl.fnsize + sizeof(LZIP);
	if (size) {
		zl.crc = ((~zip_crcval) & 0xFFFFFFFFL);
		lseek(oh, of, SEEK_SET);
		oswrite(oh, &zl, sizeof(LZIP));
		lseek(oh, zc.offset_sd, SEEK_SET);
	}
	of = 0;
	ex = zip_local.csize;
	while (wzipreadcentral(sh, &zf, 0)) {
		if (ol == zf.offset_local) {
			if (zf.extsize + zf.cmtsize)
				lseek(sh, zf.cmtsize + zf.extsize, SEEK_CUR);
			continue;
		}
		if (zf.offset_local > ol)
			zf.offset_local -= ex;
		if (wzipcopycentral(sh, oh, &zf) == 0)
			break;
		of += (zf.fnsize + zf.extsize + zf.cmtsize + sizeof(CZIP));
	}
	if (zf.signature != ZID_ENDSENTR) {
		close(sh);
		close(oh);
		arc_deltemp();
		return stderror(__outfile, EMARCHIVE, -1);
	}
	zf.signature 	= ZID_CENTRAL;
	zf.version_made = 20;
	zf.version_need = 10;
	zf.bitflag 	= 0;
	zf.method 	= 0;
	zf.time		= time;
	zf.date		= date;
	zf.crc		= zl.crc;
	zf.csize	= size;
	zf.fsize	= size;
	zf.fnsize	= zl.fnsize;
	zf.extsize	= 0;
	zf.cmtsize	= 0;
	zf.disk		= 0;
	zf.int_attrib   = 0;
	zf.ext_attrib 	= attrib;
	zf.offset_local = zip_local.fsize;
	oswrite(oh, &zf, sizeof(CZIP));
	oswrite(oh, b, zf.fnsize);
	ol = zc.offset_sd;
	osread(sh, &zc, sizeof(ZCEN));
	zc.offset_sd = ol;
	zc.size_sd = of + zf.fnsize + sizeof(CZIP);
	zc.entry_cur++;
	zc.entry_dir++;
	oswrite(oh, &zc, sizeof(ZCEN));
	if (zc.comment_size)
		copyhndl(sh, oh, zc.comment_size);
	close(sh);
	close(oh);
	progress_update(progress_size);
	return arc_renametemp();
}
