/*
 * WCENTER.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <wchar.h>
#include <string.h>

int wcenter(WCHR *wp, int lsize, const char *cp)
{
	int size = strlen(cp);

	if (size > lsize) {
		if (cp[1] == ':')
			wcputf(wp, lsize, 0, "%c:\\...%s", *cp, cp + size - lsize + 6);
		else
			wcputf(wp, lsize, 0, "\\...%s", cp + size - lsize + 4);
		return lsize;
	}
	wcputs(wp + ((lsize - size) >> 1), lsize, 0, cp);
	return size;
}
