/*
 * ATOX.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <stdlib.h>

static int get_value(int c)
{
	if (c < '0' || c > 'F')
		return -1;
	if (c <= '9')
		return c - '0';
	if (c >= 'A')
		return 10 + c - 'A';
	return -1;
}

long atox(const char *p)
{
	int c;
	long total;

	total = 0;
	while ((c = get_value(*p++)) != -1)
		total = 16 * total + c;
	return total;
}