/*
 * EDITPAL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dialog.h>
#include <string.h>

extern ROBJ *IDD_EditColor;
extern const char *cp_editcolor[];
extern const char cp_palinfo[]; /* Id   Init    Setup */

int edc_putattrib(DOBJ *);

enum {	ID_OK = 16 + 8,
	ID_CANCEL };

static DOBJ *dialog;

static int palett_event(void)
{
	int x,y,q,result;

	x = dialog->rc.x;
	y = dialog->rc.y;
	for (q = 0; q < 16; q++)
		scputf(x + 18, y + 4 + q, 0, 3, "%3d", at_palett[q]);
	result = tdxcellevent(dialog, &dialog->object[dialog->index]);
	mouseoff();
	q = dialog->index - 8;
	if (result == PGUP) {
		at_palett[q]++;
		setpal(at_palett[q], q);
	} else if (result == PGDN) {
		at_palett[q]--;
		setpal(at_palett[q], q);
	}
	mouseon();
	return result;
}

int editpal(void)
{
	int x,y,q;
	COLOR edc;

	if ((dialog = rsopen(IDD_EditColor)) == NULL)
		return 0;
	tdshow(dialog);
	memcpy(&edc, at_background, 40);
	edc_putattrib(dialog);
	x = dialog->rc.x;
	y = dialog->rc.y + 4;
	for (q = 0; q < 16; q++)
		scputs(x + 46, y + q, 0, 0, cp_editcolor[q]);
	scputs(x +  4, y - 2,  0, 0, cp_palinfo);
	scputs(x + 35, y,      0, 0, cp_editcolor[16]);
	scputs(x + 35, y + 8,  0, 0, cp_editcolor[17]);
	scputs(x + 35, y + 12, 0, 0, cp_editcolor[18]);

	for (q = 0; q < 8; q++)
		dialog->object[q].flag |= _O_STATE;
	for (q = 8; q < 16 + 8; q++)
		dialog->object[q].proc = palett_event;
	for (q = 0; q < 16; q++) {
		scputf(x + 5, y + q, 0, 7, "%X   %3d", q, at_palett[q]);
		scputf(x + 18, y + q, at_DialogKey, 3, "%3d", at_palett[q]);
	}
	q = rsevent(IDD_EditColor, dialog);
	tdclose(dialog);
	if (q == 0) {
		LoadColor(&edc);
		loadpal(at_palett);
		return 0;
	}
	return 1;
}