/*
 * FBLOCK.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_FBLOCK
#define __INC_FBLOCK

#include <dos.h>
#include <ifsmgr.h>

/* File Block-flag */
#define _A_FATTRIB	0x003F
#define _A_SELECTED	0x0040
#define _A_UPDIR	0x0080
#define _A_CDROOM	0x0100

/* -- if ZIPFILE */
#define _A_ENCRYPTED	0x0200
#define _A_EXTLOCHD	0x0400
#define _A_ARCHIVE	0xF000	/* File is inside Archive-file */
#define _A_ZIP		0x1000
#define _A_ARJ		0x2000
#define _A_GZ		0x3000
#define _A_7Z		0x4000
#define _A_CAB		0x5000
#define _A_BZ2		0x6000

#define _A_STDFILES	(_A_ARCH|_A_RDONLY|_A_SYSTEM|_A_SUBDIR)
#define _A_ALLFILES	(_A_STDFILES|_A_HIDDEN)

#define ISRDONLY(m) 	((m) & _A_RDONLY)
#define ISHIDDEN(m) 	((m) & _A_HIDDEN)
#define ISSYSTEM(m) 	((m) & _A_SYSTEM)
#define ISVOLID(m)	((m) & _A_VOLID)
#define ISSUBDIR(m) 	((m) & _A_SUBDIR)
#define ISARCH(m)   	((m) & _A_ARCH)
#define ISSELECTED(m) 	((m) & _A_SELECTED)
#define ISUPDIR(m) 	((m) & _A_UPDIR)
#define ISCDROOM(m)	((m) & _A_CDROOM)
#define ISARCHIVE(m)	((m) & _A_ARCHIVE)
#define ISARJ(m) 	(((m) & _A_ARCHIVE) == _A_ARJ)
#define ISZIP(m) 	(((m) & _A_ARCHIVE) == _A_ZIP)

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef _FBLK_DEF
#define _FBLK_DEF
typedef struct	{
	int		flag;
	unsigned	time;
	unsigned	date;
	long		size;
	char		name[2];
      } FBLK;
typedef FBLK	fblk;
#endif

FBLK *_CType fbstaticff(const ffblk *);
FBLK *_CType fballocff(const ffblk *, int __flag);
FBLK *_CType fballocwf(const wfblk *, int __flag);
FBLK *_CType fbupdir(int __flag);

int _CType fbinvert(FBLK *);
int _CType fbselect(FBLK *);

void _CType fbputdate(const FBLK *, int __x, int __y);
void _CType fbputtime(const FBLK *, int __x, int __y);

#ifdef __cplusplus
 }
#endif
#endif