/* FTIME.C--
 *
 * 03/30/2007
 *
 * Change history:
 * 09/09/2009 - Updated for WCC
 */

#include <io.h>
#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dir.h>

char cp_info[] =
"FTIME Version 1.02 BETA, Public Domain\n"
"\n"
;
char cp_usage[] =
"USAGE:     FTIME [-option] [file]\n"
"\n"
"/S         Process subfolders\n"
"/I         Include directories\n"
"\n"
"/CD<date>  Creation date:      -cdDD.MM.YY\n"
"/CT<time>  Creation time:      -ctHH:MM:SS\n"
"/MD<date>  Modification date:  -mdDD.MM.YY\n"
"/MT<time>  Modification time:  -mtHH:MM:SS\n"
"/AD<date>  Last access date:   -adDD.MM.YY\n"
"\n"
;

char cp_ldatefrm[] = "%02d.%02d.%d";
char cp_ltimefrm[] = "%02d:%02d:%02d";
char __spath[WMAXPATH];
char __smask[WMAXPATH];

wfblk ifsblock;

WORD time_access;	/* new time and date */
WORD time_create;
WORD time_modified;
WORD date_access;
WORD date_create;
WORD date_modified;

int do_subdir;
int ex_subdir;
int count;

int __setfdate(char *p, wfblk *wf)
{
	int handle;
	char fname[WMAXPATH];

	if (wf != NULL) {
		if (wf->shname[0])
			strfcat(fname, p, wf->shname);
		else
			strfcat(fname, p, wf->name);
		printf("  %s\n", fname);
	} else {
		strcpy(fname, p);
		printf("%s\n", fname);
		wf = &ifsblock;
	}
	if (_ifsmgr) {
		if (date_modified || time_modified) {
			if (date_modified && time_modified)
				wsetwrdate(fname, date_modified, time_modified);
			else if (date_modified)
				wsetwrdate(fname, date_modified, wf->time_modified);
			else if (time_modified)
				wsetwrdate(fname, wf->date_modified, time_modified);
		}
		if (date_create || time_create) {
			if (date_create && time_create)
				wsetcrdate(fname, date_create, time_create);
			else if (date_create)
				wsetcrdate(fname, date_create, wf->time_create);
			else if (time_create)
				wsetcrdate(fname, wf->date_create, time_create);
		}
		if (date_access)
			wsetacdate(fname, date_access);
		count++;
		return 0;
	}
	if ((handle = osopen(fname, _A_NORMAL, M_RDONLY, A_OPEN)) != -1) {
		if (date_modified || time_modified) {
			if (date_modified && time_modified)
				setfdate(handle, date_modified, time_modified);
			else if (date_modified)
				setfdate(handle, date_modified, wf->time_modified);
			else if (time_modified)
				setfdate(handle, wf->date_modified, time_modified);
		}
		close(handle);
		count++;
		return 0;
	}
	return -1;
}

int __dofiles(char *p, wfblk *wf)
{
	char fname[WMAXPATH];

	if (__setfdate(p, wf) == 0)
		return 0;
	return -1;
}

int __dodirectory(char *p)
{
	if (scan_files(p) == 0) {
		if (ex_subdir)
			return 0;
		return  __setfdate(p, NULL);
	}
	return -1;
}

int __setdirectory(char *name)
{
	char fname[WMAXPATH];

	strfcat(fname, __spath, wshortname(name));
	if (do_subdir)
		return scan_directory(0, fname);
	if (ex_subdir)
		return 0;
	return  __setfdate(fname, NULL);
}

int readff(void)
{
	ffblk ff;
	char mask[256];
	int count;
	wfblk *wf;

	wf = &ifsblock;
	wf->shname[0] = 0;
	count = 0;
	strfcat(mask, __spath, __smask);
	if (findfirst(mask, &ff, _A_ALLFILES))
		return 0;
	if (ff.ff_name[0] == '.' && ff.ff_name[1] == 0) {
		if (findnext(&ff))
			return 0;
		if (ff.ff_name[0] == '.' && ff.ff_name[2] == 0) {
			if (findnext(&ff))
				return 0;
		}
	} do {
		if (ff.ff_attrib & _A_SUBDIR) {
			if (__setdirectory(ff.ff_name))
				break;
		} else {
			strcpy(wf->name, ff.ff_name);
			wf->date_modified = ff.ff_ftime;
			wf->time_modified = ff.ff_fdate;
			__setfdate(__spath, wf);
		}
	} while (findnext(&ff) == 0);
	return count;
}

int readwf(void)
{
	int handle;
	wfblk *ff;
	char mask[256];

	ff = &ifsblock;
	strfcat(mask, __spath, __smask);
	if ((handle = wfindfirst(mask, ff, _A_ALLFILES)) == -1)
		return 0;
	if (ff->name[0] == '.' && ff->name[1] == 0) {
		if (wfindnext(ff, handle)) {
			wcloseff(handle);
			return 0;
		}
		if (ff->name[0] == '.' && ff->name[2] == 0) {
			if (wfindnext(ff, handle)) {
				wcloseff(handle);
				return 0;
			}
		}
	} do {
		if (ff->attrib & _A_SUBDIR) {
			if (__setdirectory(ff->name))
				break;
		} else {
			__setfdate(__spath, ff);
		}
	} while (wfindnext(ff, handle) == 0);
	wcloseff(handle);
	return 0;
}

int main(/*int argc, char **argv*/)
{
	int 	c,mask;
	int	setnewdate;
	char *	p;
	BYTE	clear;
	char    b[64];

	printf(cp_info);
	if (_argc == 1) {
		printf(cp_usage);
		return 1;
	}
	__smask[0] = 0;
	ex_subdir = 1;
	for (c = 1; c < _argc; c++) {
		switch (_argv[c][0]) {
		case '?':
			puts(cp_usage);
			return 0;
		case '/':
		case '-':
			switch (_argv[c][1] | 0x20) {
			case 'c':
				if ((_argv[c][2] | 0x20) == 'd')
					date_create = strtodw(&_argv[c][3]);
				else
					time_create = strtotw(&_argv[c][3]);
				break;
			case 'm':
				if ((_argv[c][2] | 0x20) == 'd')
					date_modified = strtodw(&_argv[c][3]);
				else
					time_modified = strtotw(&_argv[c][3]);
				break;
			case 'a':
				if ((_argv[c][2] | 0x20) == 'd')
					date_access = strtodw(&_argv[c][3]);
				else
					time_access = strtotw(&_argv[c][3]);
				break;
			case 's':
				do_subdir++;
				break;
			case 'i':
				ex_subdir = 0;
				break;
			default:
				puts(cp_usage);
				return 0;
			}
			break;
		default:
			strcpy(__spath, _argv[c]);
			strcpy(__smask, strfn(_argv[c]));
			p = strstr(__spath, __smask);
			if (p > __spath && *(p-1) == '\\')
				*(p-1) = 0;
			else
				*p = 0;
			break;
		}
	}
	setnewdate =
		time_access   +
		time_create   +
		time_modified +
		date_access   +
		date_create   +
		date_modified;

	if (setnewdate == 0 || __smask[0] == 0) {
		perror("Nothing to do..");
		return 0;
	}
	if (__spath[0] == 0) {
		if (fullpath(__spath, 0) == NULL) {
			perror("Error init current path");
			return 1;
		}
	}
	if (time_create)
		printf("   Creation time:       %s\n", twtostr(b, time_create));
	if (date_create)
		printf("   Creation date:       %s\n", dwtostr(b, date_create));
	if (time_modified)
		printf("   Modification time:   %s\n", twtostr(b, time_modified));
	if (date_modified)
		printf("   Modification date:   %s\n", dwtostr(b, date_modified));
	if (date_access)
		printf("   Last access date:    %s\n", dwtostr(b, date_access));
	printf("\nFile(s):   %s\n", __smask);
	printf("Directory: %s\n\n", __spath);
	fp_maskp = __smask;
	fp_fileblock = __dofiles;
	fp_directory = __dodirectory;
	if (_ifsmgr)
		readwf();
	else
		readff();
	printf("\nTotal %d files updated\n", count);
	return 0;
}
