include doszip/doszip.inc
include dos.inc
include string.inc
include confirm.inc
include progress.inc
include errno.inc

ifdef __ZIP__
include iost.inc
include unzip.inc
extrn	foreslash:byte
extrn	cp_ziptemp:byte
extrn	arc_flength:dword
extrn	zip_copyendcentral:dist
endif

_DATA	SEGMENT

__spath	db  66 dup(?)
__cdir	db 256 dup(?)

_DATA	ENDS

_DZIP	SEGMENT

setconfirmflag proc public
	mov	dx,CFSELECTED
	mov	al,config.c_confirm
	test	al,_C_CONFDELETE
	jz	@F
	or	dx,CFDELETEALL
      @@:
	test	al,_C_CONFDELSUB
	jz	@F
	or	dx,CFDIRECTORY
      @@:
	test	al,_C_CONFSYSTEM
	jz	@F
	or	dx,CFSYSTEM
      @@:
	test	al,_C_CONFRDONLY
	jz	@F
	or	dx,CFREADONY
      @@:
	mov	confirmflag,dx
	ret
setconfirmflag endp

open_progress proc
	invoke	setconfirmflag
	invoke	progress_open,addr cp_delete,0
	ret
open_progress endp

remove_file proc pascal directory:dword, filename:dword, attrib:word
local	path[WMAXPATH]:byte
	invoke	progress_set,filename,directory,0
	jnz	remove_file_end
	invoke	confirm_delete_file,filename,attrib
	test	ax,ax
	jz	remove_file_end
	inc	ax ; -1 --> 1
	jnz	@F
	inc	ax
	jmp	remove_file_end
      @@:
	invoke	strfcat,addr path,directory,filename
	mov	ax,attrib
	test	al,_A_RDONLY
	jz	@F
	invoke	setfattr,addr path,0
      @@:
	invoke	remove,addr path
  ifdef __LFN__
	test	ax,ax
	jz	@F
	invoke	wlongpath,addr path,0
	invoke	remove,dx::ax
      @@:
  endif
	test	ax,ax
	jz	remove_file_end
	mov	dx,ss
	lea	ax,path
	call	erdelete
    remove_file_end:
	ret
remove_file endp

remove_directory proc pascal directory:dword
      ifdef __LFN__
	invoke	wshortname,directory
      else
	lodm	directory
      endif
	invoke	strfcat,addr __cdir,addr __spath,dx::ax
	invoke	confirm_delete_sub,dx::ax
	cmp	ax,1
	jne	@F
	invoke	scan_directory,0,addr __cdir
      @@:
	ret
remove_directory endp

fp_remove_file proc DIST pascal directory:dword, wfblock:dword
	les	bx,wfblock
	invoke	remove_file,directory,addr es:[bx].wf_name,es:[bx].wf_attrib
	ret
fp_remove_file endp

fp_remove_directory proc DIST pascal directory:dword
	invoke	progress_set,0,directory,1
	jnz	@F
	invoke	scan_files,directory
	push	ax
	invoke	setfattr,directory,0
	invoke	rmdir,directory
	pop	ax
      @@:
	ret
fp_remove_directory endp

cmdelete_remove proc
	mov	di,fb_name+4
	test	dl,_A_SUBDIR
	jz	@F
	invoke	remove_directory,bp::di
	jmp	cmdelete_remove_end
      @@:
	invoke	remove_file,ds::si,bp::di,dx
  ifdef __LFN__
	test	ax,ax
	jz	@F
	invoke	wshortname,bp::di
	mov	es,bp
	sub	di,fb_name
	invoke	remove_file,ds::si,dx::ax,es:[di].fb_flag
      @@:
  endif
    cmdelete_remove_end:
	mov	di,ax
	test	ax,ax
	ret
cmdelete_remove endp

ifdef __ZIP__

wsdeletearc:
	push	bp
	push	si
	push	di
	mov	bp,ax	; SS:BP = wsub
	mov	si,dx	; SI:DI = fblk
	mov	di,bx
	xor	ax,ax
    delete_zip_file:
	mov	bx,ax
	test	ax,ax	; AX set if repeated call with same directory
	jz	@F
	mov	ax,offset entryname
	jmp	wzipdel_progress
      @@:
	push	bx
	mov	es,si
	mov	cx,es:[di]
	mov	dx,si
	mov	ax,di
	add	ax,S_FBLK.fb_name
	test	cl,_A_SUBDIR
	jz	@F
	invoke	confirm_delete_sub,dx::ax
	jmp	wzipdel_confirm
      @@:
	invoke	confirm_delete_file,dx::ax,cx
    wzipdel_confirm:
	pop	bx
	test	ax,ax
	jnz	@F
	jmp	wzipdel_end		; 0: Skip file
      @@:
	inc	ax
	jnz	@F
	jmp	wzipdel_cancel		; -1: Cancel
      @@:
	invoke	strfcat,addr __srcfile,[bp].ws_path,[bp].ws_file
	invoke	strcpy,addr __outfile,dx::ax
	mov	dx,offset cp_ziptemp
	call	addext
	mov	ax,di
	add	ax,S_FBLK.fb_name
	invoke	strfcat,addr __outpath,[bp].ws_arch,si::ax
	invoke	dostounix,dx::ax
	mov	es,si
	test	byte ptr es:[di],_A_SUBDIR
	jz      @F
	invoke	strcat,dx::ax,addr foreslash
      @@:
	invoke	strcmp,addr __srcfile,addr __outfile
	test	ax,ax
	jnz	@F
	jmp	wzipdel_err
      @@:
	mov	ax,offset __outpath
    wzipdel_progress:
	push	bx
	invoke	progress_set,ds::ax,addr __srcfile,arc_flength
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	wscopy_open
	pop	bx
	cmp	ax,-1
	jne	@F
	jmp	zip_delete_end
      @@:
	mov	STDO.ios_flag,IO_UPDTOTAL or IO_USEUPD
	test	ax,ax
	jz	zip_delete_error
	xor	bx,1		; 0: match directory\*.*
	push	bx		; 1: exact match -- file or directory/
	push	bx
	call	zip_copylocal	; copy compressed data to temp file
	pop	es		; local offset in DX:CX if found
	inc	ax
	jz	zip_delete_error
	push	es
	push	dx		; Central directory
	push	cx		; offset local if found
	lodm	STDO.ios_total
	add	ax,STDO.ios_i
	adc	dx,0
	mov	cx,word ptr zip_endcent.ze_off_cent+2
	mov	bx,word ptr zip_endcent.ze_off_cent
	stom	zip_endcent.ze_off_cent
	sub	bx,ax
	sbb	cx,dx
	push	cx
	push	bx
	push	es
	call	zip_copycentral
	pop	bx
	dec	ax
	jnz	zip_delete_error	; must be found..
	xor	ax,ax      	;-------- End Central Directory
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	push	ax
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	zip_copyendcentral
	inc	ax
	pop	ax
	jnz	zip_delete_end
    zip_delete_error:
	push	bx
	invoke	oclose,addr STDI
	mov	ax,offset __outfile
	call	wscopy_remove
	pop	ax
	test	ax,ax
	jz	@F
	dec	ax
	jmp	wzipdel_end
      @@:
	inc	ax
    zip_delete_end:
	mov	es,si
	mov	dl,es:[di]
	and	dl,_A_SUBDIR
	jnz	wzipdel_end
	cmp	ax,1
	jne	wzipdel_end
    wzipdel_err:		; 2: ZIP file deleted (Ok)
	mov	dx,ds
	mov	ax,offset __outpath
	cmp	errno,0
	jne	@F
	mov	errno,ENOENT
      @@:
	call	erdelete
	inc	ax
    wzipdel_cancel:
	inc	ax
    wzipdel_end:		; 0: Jump/Ok/Continue
	test	ax,ax
	jnz	wsdeletearc_end
	mov	es,si
	mov	cx,es:[di]
	test	cl,_A_SUBDIR
	jz	wsdeletearc_end
	inc	ax
	jmp	delete_zip_file
    wsdeletearc_end:
	test	ax,ax
	pop	di
	pop	si
	pop	bp
	ret

cmdeletezip:	; DX:BX = fblk, CX = flag
	push	bp
	push	si
	push	di
	mov	si,dx
	mov	di,bx
	mov	bp,cx
	sub	ax,ax
	test	cx,_A_ARCHZIP
	jz	cmdeletezip_end
	call	open_progress
      @@:
	mov	bx,cpanel
	mov	ax,word ptr [bx].pn_wsub
	mov	bx,di
	mov	dx,si
	call	wsdeletearc
	test	ax,ax
	jnz	@F
	mov	ax,es:[di]
	and	ax,not _A_SELECTED
	mov	es:[di],ax
	mov	ax,cpanel
	call	panel_findnext
	jz	@F
	mov	si,dx
	mov	di,bx
	jmp	@B
      @@:
	call	ret_update_AB
    cmdeletezip_end:
	pop	di
	pop	si
	pop	bp
	ret

endif ; __ZIP__

cmdelete proc DIST public
	push	bp
	push	si
	push	di
	call	cpanel_findfirst
	jz	cmdelete_end
  ifdef __ROT__
	test	cx,_A_ROOTDIR
	jnz	cmdelete_end
  endif
  ifdef __DLL__
	test	cx,_A_ARCHEXT
	jz	@F
	mov	cx,bx
	mov	bx,cpanel
	mov	bx,word ptr [bx].pn_wsub
	mov	ah,_DLL_DELETE
	int	DLL
	call	ret_update_AB
	jmp	cmdelete_end
      @@:
  endif
  ifdef __ZIP__
	test	cx,_A_ARCHIVE
	jz	@F
	call	cmdeletezip
	jmp	cmdelete_end
      @@:
  endif
	mov	bp,dx
	mov	si,offset __spath
	mov	bx,cpanel
	mov	bx,[bx]
	mov	ax,[bx]
	and	ax,_W_NETWORK
	cmp	ax,_W_NETWORK
	jne	@F
	invoke	strcpy,ds::si,addr [bx].wp_path
	jmp	cmdelete_00
      @@:
	invoke	fullpath,ds::si,0
	test	ax,ax
	jz	cmdelete_end
    cmdelete_00:
	stoso	fp_maskp,ds,offset cp_stdmask
	fpmov	fp_fileblock,fp_remove_file
	fpmov	fp_directory,fp_remove_directory
	call	open_progress
	mov	es,bp
	mov	bx,4
	mov	dx,es:[bx]
	test	dx,_A_SELECTED
	jz	cmdelete_01
      @@:
	jz	cmdelete_02
	call	cmdelete_remove
	test	ax,ax
	jz	cmdelete_02
	mov	es,bp
	mov	bx,4
	and	byte ptr es:[bx],not _A_SELECTED
	mov	ax,cpanel
	call	panel_findnext
	mov	bp,dx
	mov	dx,cx
	jmp	@B
    cmdelete_01:
	call	cmdelete_remove
    cmdelete_02:
	mov	ax,di
	call	ret_update_AB
    cmdelete_end:
	pop	di
	pop	si
	pop	bp
	ret
cmdelete endp

_DZIP	ENDS

	END
