;
; MACRO.INC
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

.XLIST

SCRSEG		EQU	0B800h

Instruction	MACRO	ins,des,src,MOD,mem
		IFNB <mem>
		    IFIDNI <PTR>,<MOD>
			ins des, src MOD mem
		    ELSE
			IFIDNI <PTR>,<src>
			    ins des src MOD, mem
			ELSE
			    err
			ENDIF
		    ENDIF
		ELSE
		    IFNB <MOD>
			IFIDNI <prt>,<src>
			    ins des src MOD
			ELSE
			    IFIDNI <OFFSET>,<src>
				ins des,src MOD
			    ELSE
				IFIDNI <OFFSET>,<des>
				    ins des src,MOD
				ELSE
				    IFIDNI <SEG>,<src>
					ins des,src MOD
				    ELSE
					err
				    ENDIF
				ENDIF
			    ENDIF
			ENDIF
		    ELSE
			IFNB <src>
			    IFIDNI <SHORT>,<des>
				ins des src
			    ELSE
				ins des,src
			    ENDIF
			ELSE
			    IFNB <des>
				ins des
			    ELSE
				ins
			    ENDIF
			ENDIF
		    ENDIF
		ENDIF
		ENDM

IFND		MACRO ins,des,src,MOD,mem
		IFNDEF LDATA
			Instruction ins,des,src,MOD,mem
		ENDIF
		ENDM

IFFD		MACRO ins,des,src,MOD,mem
		IFDEF LDATA
			Instruction ins,des,src,MOD,mem
		ENDIF
		ENDM

DBUG		MACRO ins,des,src,MOD,mem
		IFDEF DEBUG
			Instruction ins,des,src,MOD,mem
		ENDIF
		ENDM
NPROC		MACRO N
_TEXT		SEGMENT
		N PROC NEAR
		ENDM

LPROC		MACRO N, D, T
_TEXT		SEGMENT
		IFNB <D>
		    IFNB <T>
			N PROC T D
		    ELSE
			N PROC PASCAL D
		    ENDIF
		ELSE
		    N PROC PASCAL NEAR
		ENDIF
		ENDM

PPROC		MACRO N, D, T
_TEXT		SEGMENT
		IFNB <D>
		    IFNB <T>
			N PROC T D
			PUBLIC T N
		    ELSE
			N PROC PASCAL D
			PUBLIC PASCAL N
		    ENDIF
		ELSE
		    N PROC PASCAL DIST
		    PUBLIC PASCAL N
		ENDIF
		ENDM

PEND		MACRO N
		N ENDP
_TEXT 		ENDS
		ENDM

LOCDATA		MACRO	N, T, V, C
_DATA		SEGMENT
		IFNB <V>
		    IFNB <C>
			N T C DUP(V)
		    ELSE
			N T V
		    ENDIF
		ELSE
		    N T ?
		ENDIF
_DATA		ENDS
		ENDM

GLOBDATA	MACRO	N, T, V, C
		PUBLIC  N
		LOCDATA N T V C
		ENDM

INITPROC	MACRO	N, D, PRIORITY
_INIT_		SEGMENT WORD USE16 PUBLIC 'INITDATA'
		DB	D
		DB	PRIORITY
		DD	_TEXT:N
_INIT_		ENDS
		ENDM

EXITPROC	MACRO	N, D, PRIORITY
_EXIT_		SEGMENT WORD USE16 PUBLIC 'EXITDATA'
		DB	D
		DB	PRIORITY
		DD	_TEXT:N
_EXIT_		ENDS
		ENDM

IFNDEF 	__C0__
		GLOBAL	_psp:		WORD
		GLOBAL	envseg:		WORD
		GLOBAL	envlen:		WORD
		GLOBAL	envsize:	WORD
		GLOBAL	c0argc:		WORD
		GLOBAL	c0argv:		WORD
		GLOBAL	C0environ:	WORD
		GLOBAL	_osminor:	BYTE
		GLOBAL	_osmajor:	BYTE
		GLOBAL	_osversion:	WORD
		GLOBAL	errno:		WORD
		GLOBAL	doserrno:	WORD
		GLOBAL  sys_erdevice:	DWORD
		GLOBAL  sys_ercode:	WORD
		GLOBAL  sys_erflag:	BYTE
		GLOBAL 	sys_erdrive:	BYTE
	IFND	GLOBAL	__heapbase:	WORD
		GLOBAL	_heaptop:	WORD	; DWORD
		GLOBAL	_heapbase:	WORD	; DWORD
		GLOBAL	_brklvl:	WORD	; DWORD
		GLOBAL	DGROUP@:	WORD
IFNDEF __HUGE__
		GLOBAL	__brklvl:	WORD
ENDIF
		GLOBAL	stderrmsg:	NEAR

ENDIF	; __C0__

.LIST