/*
 * CMTOOLS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <dzmain.h>

static ROBJ *IDD_ToolsDLG;
extern TOBJ tobj_menusline[];

const char cp_tools[] = "Tools";

int tools_modalidd(int bsize, char *b, const char *idd)
{
	int 	x;
	int	result;
	char *	p;
	char *	q;
	char 	entry[WMAXPATH];
	DOBJ 	mu;
	DOBJ *	d;
	TOBJ *	o;
	WCHR 	mb[30];
	WCHR 	stl[80];
	RECT	rc;

	result  = 0;
	if ((d = rsopen(IDD_ToolsDLG)) == NULL)
		return result;
	mu.wp   = mb;
	mu.rc   = tobj_menusline[4].rc;
	mu.flag = _D_COLOR|_D_MYBUF;
	if (twopen(&mu, at_MenusKey & 0x0F, NULL))
		twshow(&mu);
	o = d->object;
	for (x = 0; x < MAXUSERITEM; x++) {
		if ((p = inientryid(idd, x)) == NULL)
			break;
		if ((q = strchr(p, ',')) != NULL) {
			*q++ = 0;
			q = strstart(q);
			if (*q == '[') {
				strncpy(o[x].data, q + 1, 33);
				if ((q = strchr(o[x].data, ']')) != NULL)
					*q = 0;
				o[x].flag |= _O_FLAGB;
			} else {
				strncpy(o[x].data, q, bsize);
			}
		} else {
			strncpy(o[x].data, p, bsize);
			o[x].flag |= _O_FLAGB;
		}
		if (p[0] == '<' && p[1] == '>') {
			wcputc(rcbprc(d->wp, o[x].rc, d->rc.col) - 1, 38, 196);
			o[x].flag &= ~_O_FLAGB;
		} else {
			wcputs(rcbprc(d->wp + 1, o[x].rc, d->rc.col), 0, 32, p);
			o[x].flag &= ~_O_STATE;
			result++;
			if ((p = strchr(p, '&')) != NULL) {
				o[x].ascii = p[1];
			}
		}
	}
	if (result == 0) {
		twclose(&mu);
		tdclose(d);
		return result;
	}

	d->count = x;
	d->rc.row = x + 2;
	rc = d->rc;
	rc.x = 0;
	rc.y = 0;
	rcframe(rc, d->wp, 38, 0);
	strncpy(entry, idd, 16);
	entry[16] = 0;
	wcpushst(stl, entry);
	tdinit(d);
	result = tdevent(d);
	x  = (o[result - 1].flag & (_O_STATE | _O_FLAGB));
	strncpy(entry, o[result - 1].data, bsize);
	wcpopst(stl);
	twclose(&mu);
	tdclose(d);
	if (result > 0 && result <= d->count) {
		if (x & _O_FLAGB)
			return tools_modalidd(bsize, b, entry);
		if (b != NULL)
			strcpy(b, entry);
		else
			return ex_command(entry);
	} else if (mousep()) {
		return MOUSECMD;
	}
	return result;
}

static int cmtool(int id)
{
	char *p,*q;
	char b[128];

	if ((p = inientryid(cp_tools, id)) == NULL)
		return 0;
	if (p[0] == '<' && p[1] == '>')
		return 0;
	if ((q = strchr(p, ',')) == NULL)
		return 0;
	strncpy(b, strstart(q + 1), 128);
	if (*b != '[')
		return ex_command(b);
	strcpy(b, b + 1);
	if ((q = strchr(b, ']')) != NULL)
		*q = 0;
	else
		return 0;
	return tools_modalidd(128, NULL, b);
}

int cmtool0(void) { return cmtool(0); }
int cmtool1(void) { return cmtool(1); }
int cmtool2(void) { return cmtool(2); }
int cmtool3(void) { return cmtool(3); }
int cmtool4(void) { return cmtool(4); }
int cmtool5(void) { return cmtool(5); }
int cmtool6(void) { return cmtool(6); }
int cmtool7(void) { return cmtool(7); }
int cmtool8(void) { return cmtool(8); }
int cmtool9(void) { return cmtool(9); }

#define _RCEDIT_
/******** Resource begin ToolsDLG *
	{ 0x2418,  20,   0, {32, 1,38,22} },
	{ 0x8005,   8,   0, { 2, 1,34, 1} },
	{ 0x8005,   8,   0, { 2, 2,34, 1} },
	{ 0x8005,   8,   0, { 2, 3,34, 1} },
	{ 0x8005,   8,   0, { 2, 4,34, 1} },
	{ 0x8005,   8,   0, { 2, 5,34, 1} },
	{ 0x8005,   8,   0, { 2, 6,34, 1} },
	{ 0x8005,   8,   0, { 2, 7,34, 1} },
	{ 0x8005,   8,   0, { 2, 8,34, 1} },
	{ 0x8005,   8,   0, { 2, 9,34, 1} },
	{ 0x8005,   8,   0, { 2,10,34, 1} },
	{ 0x8005,   8,   0, { 2,11,34, 1} },
	{ 0x8005,   8,   0, { 2,12,34, 1} },
	{ 0x8005,   8,   0, { 2,13,34, 1} },
	{ 0x8005,   8,   0, { 2,14,34, 1} },
	{ 0x8005,   8,   0, { 2,15,34, 1} },
	{ 0x8005,   8,   0, { 2,16,34, 1} },
	{ 0x8005,   8,   0, { 2,17,34, 1} },
	{ 0x8005,   8,   0, { 2,18,34, 1} },
	{ 0x8005,   8,   0, { 2,19,34, 1} },
	{ 0x8005,   8,   0, { 2,20,34, 1} },
********* Resource data  *******************/
static int ToolsDLG_RC[] = {
#ifdef _RCEDIT_
	0x1228,0x2418,0x0014,0x0120,0x1626,0x8005,0x0008,0x0102,
	0x0122,0x8005,0x0008,0x0202,0x0122,0x8005,0x0008,0x0302,
	0x0122,0x8005,0x0008,0x0402,0x0122,0x8005,0x0008,0x0502,
	0x0122,0x8005,0x0008,0x0602,0x0122,0x8005,0x0008,0x0702,
	0x0122,0x8005,0x0008,0x0802,0x0122,0x8005,0x0008,0x0902,
	0x0122,0x8005,0x0008,0x0A02,0x0122,0x8005,0x0008,0x0B02,
	0x0122,0x8005,0x0008,0x0C02,0x0122,0x8005,0x0008,0x0D02,
	0x0122,0x8005,0x0008,0x0E02,0x0122,0x8005,0x0008,0x0F02,
	0x0122,0x8005,0x0008,0x1002,0x0122,0x8005,0x0008,0x1102,
	0x0122,0x8005,0x0008,0x1202,0x0122,0x8005,0x0008,0x1302,
	0x0122,0x8005,0x0008,0x1402,0x0122,
#endif
	0x44F3,0xF33B,0x2044,0x3B3B,
}; //	178 byte
ROBJ *IDD_ToolsDLG = (ROBJ *)&ToolsDLG_RC;
/******** Resource end   ToolsDLG */
