/*
 * CMEGALIN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <conio.h>
#include <dzmain.h>

int aputsl(const char *);
void apisetlcount(int);

int return_Alt(int result)
{
	while (shift->Alt)
		;
	return result;
}

int cmegaline(void)
{
	if (cflag & _C_EGALINE) {
		cflag &= ~_C_EGALINE;
		if (*__egaline == 24)
			return return_Alt(0);
		scputw(0, *__egaline, 80, MKW(0x07,' '));
		apisetlcount(24);
		redraw_panels();
		com_egaline();
		aputsl(cp_statusline);
		return return_Alt(0);
	}
	cflag |= _C_EGALINE;
	scputw(0, *__egaline, 80, MKW(0x07,' '));
	apisetlcount(49);
	com_egaline();
	redraw_panels();
	aputsl(cp_statusline);
	return return_Alt(1);
}

void redraw_panels(void)
{
	int a = panel_state(&panela);
	int b = panel_state(&panelb);

	if (a && b) {
		panel_hide(&panela);
		panel_hide(&panelb);
		if (cflag & _C_PANELID) {
			panel_show(&panela);
			panel_show(&panelb);
		} else {
			panel_show(&panelb);
			panel_show(&panela);
		}
	} else {
		if (a)
			panel_show(&panela);
		if (b)
			panel_show(&panelb);
	}
}