/*
 * WSMKDIR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <wsub.h>
#include <arch.h>
#include <time.h>
#include <errno.h>
#include <string.h>

extern const char cp_mkdir[];
extern const char cp_ermkdir[];

int notsup(void);

int wsmkdirlocal(const char *directory)
{
	if (mkdir(directory) == 0)
		return 1;
	return ermsg(cp_mkdir, cp_ermkdir, directory, sys_errlist[errno]);
}

int wsmkdirzip(WSUB *w, const char *directory)
{
	strfcat(__outfile, w->path, w->file);
	if (w->arch[0])
		strcpy(__outpath, w->arch);
	else
		__outpath[0] = 0;
	strcpy(__srcfile, directory);
	strcat(__srcfile, "/");
	if (wzipadd(0L, dwdosdate(), twdostime(), _A_SUBDIR))
		return 0;
	return 1;
}

int wsmkdir(WSUB *w, char *directory)
{
	switch (*w->flag & _W_ARCHIVE) {
	case 0:
		return wsmkdirlocal(directory);
	case _W_ZIP:
		return wsmkdirzip(w, directory);
	default:
		return notsup();
	}
}
