;
; DELAY.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc

		.386p

_TEXT		SEGMENT

multiplier	DD 	(1193 * 2)

dummy:		push	si
		push	di
		pop	di
		pop	si
		ret

Readtimer:	pushf
		cli
		xor	ax,ax
		out	43h,al  ; latch timer 0
		call	dummy
		in	al,40h
		mov	dl,al	; LSB in DL
		call	dummy
		in	al,40h
		mov	dh,al	; MSB in DH
		not	dx
		popf
		ret

Install:	mov	cx,100
@@start:	call	Readtimer
		and	dx,1
		jnz	short @@loop
		mov	cs:[multiplier],1193
		jmp	short @@toend
@@loop:		loop	short @@start
@@toend:	ret

_TEXT		ENDS

INITPROC	Install, 0, 16

PPROC		delay
ARG		msec:	WORD
		call	Readtimer
		mov	bx,dx
		movzx	eax,dx
		movzx	edx,msec
		imul	edx,cs:[multiplier]
		add	eax,edx
		mov	ecx,eax
		jmp	short @@loop
@@start:	cmp	dx,bx
		jae	short @@
		cmp	ecx,10000h
		jb	short @@toend
		sub	ecx,10000h
@@:		mov	bx,dx
@@loop:         call	Readtimer
		movzx	eax,dx
		cmp	eax,ecx
		jb	short @@start
@@toend:	ret
PEND		delay

		END

