/*
 * DOS.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 *
 *  __drv:  (00h = A:, 01h = B:, etc)
 *  __disk: (00h = default, 01h = A:, etc)
 */
#ifndef __INC_DOS
#define __INC_DOS
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

extern  int    	_CType _argc;
extern  char **	_CType _argv;
extern  char **	_CType _environ;
extern  WORD	_CType _psp;
extern 	WORD	_CType _heaplen;
extern  BYTE	_CType _osmajor;
extern  BYTE	_CType _osminor;
extern 	WORD	_CType _stklen;
extern  WORD	_CType _osversion;
extern  WORD	_CType _ifsmgr;

#define _A_NORMAL       0x00
#define _A_RDONLY       0x01
#define _A_HIDDEN       0x02
#define _A_SYSTEM       0x04
#define _A_VOLID    	0x08
#define _A_SUBDIR       0x10
#define _A_ARCH         0x20

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef _FFBLK_DEF
#define _FFBLK_DEF
typedef struct {
	char	 reserved[21];
	char     ff_attrib;
	unsigned ff_ftime;
	unsigned ff_fdate;
	DWORD	 ff_fsize;
	char     ff_name[13];
} ffblk;
#endif

int _CType findfirst(const char *, ffblk *, int);
int _CType findnext(ffblk *);

int _CType remove(const char *__fn);
void _CType delay(unsigned __milliseconds);
int _CType setblock(unsigned __segx, unsigned __newsize);

#define MK_FP(seg,ofs)	((void _seg *)(seg)+(void near *)(ofs))
#define FP_SEG(fp)	((unsigned)(void _seg *)(void far *)(fp))
#define FP_OFF(fp)	((unsigned)(fp))

void _CType beep(unsigned __hz, unsigned __time);
int _CType filexist(const char *__f);
int _CType setfdate(int __handle, int __date, int __time);
int _CType setfattr(const char *__f, int __newattr);
int _CType getfattr(const char *__f);
int _CType wabsread(int __drv, int __nsects, long l__sect, void *__buf);

#ifdef __cplusplus
 }
#endif
#endif