/*
 * DZPANEL.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#ifndef __INC_PANEL
#define __INC_PANEL

#include <dir.h>
#include <wsub.h>
#include <stdio.h>
#include <xcell.h>
#include <dialog.h>

#define MAXPANELS	2
#define MAXFBLOCK	3000

#define DEFAULTPFLAG	(_W_VISIBLE | _W_MINISTATUS | _W_SORTTYPE)

#define PN_XYCONFIG	7
#define PN_XYMINISTATUS	6
#define PN_XYNEWDISK	5
#define PN_XYMOVEUP	4
#define PN_XYMOVEDOWN	3
#define PN_XYFILE	2
#define PN_XYINSIDE	1
#define PN_XYOUTSIDE	0

#define SCR_CLEARW	0
#define SCR_MOVEUP	1
#define SCR_MOVEDN	2
#define SCR_DONOTHING	3

typedef struct {
	WORD *	flag;
	int	fcb_count;
	int	fcb_index;
	int	cel_count;
	int	cel_index;
	XCEL *	xl;
	DOBJ *	dialog;
	WSUB *	ide;
	void (* putfcb)(const FBLK *, int, int);
      } panel;

extern	panel *	cpanel;
extern	panel	spanel[MAXPANELS];
#define panela	spanel[0]
#define panelb	spanel[1]
extern	XCEL	panel_xcell[MAXPANELS];
extern	DOBJ	panel_wbox[MAXPANELS];
extern  WSUB 	wspanel[MAXPANELS];

extern int numfblock;

extern const char cp_ldatefrm[];
extern const char cp_ltimefrm[];
extern const char cp_stdmask[];
extern const char cp_userabort[];

int init_panels(void);
int open_panels(void);

int panel_open(panel *);
int panel_close(panel *);
int panel_show(panel *);
int panel_hide(panel *);
int panel_state(panel *);
int panel_toggle(panel *);
int panel_hndevent(panel *, int __event);
int panel_alloc_array(panel *);
int panel_free_fcb(panel *);
int panel_read(panel *);
int panel_inithdd(panel *, int __hdd);
int panel_sethdd(panel *, int);
int panel_update_fcb(panel *);
int panel_update_rect(panel *);
int panel_update_all(panel *);
void panel_sort(panel *, int __type);

FBLK *panel_curobj(panel *);
FBLK *panel_ffselected(panel *);
int   panel_numselected(panel *);
DWORD panel_sizeselected(panel *);

void panel_setactive(panel *);
void panel_putinfo(panel *);
void panel_putmini(panel *);
void panel_putitem(panel *, int __clrflag);

int panel_setid(panel *, int);
int panel_xycmd(panel *, int __x, int __y);
int panel_togglemini(panel *);
int init_cpanel(void);

FBLK *cpanel_findfirst(void);
char *cpanel_gettarget(void);

void prect_open(panel *);
int prect_close(panel *);
int prect_hide(panel *);
int prect_show(panel *);

void redraw_panels(void);

int pcell_show(panel *);
int pcell_update(panel *);
int pcell_set(panel *);
int pcell_setxy(panel *, int, int);
int pcell_select(panel *);
int pcell_move(panel *);
#define pcell_hide(p) xl_close(p->xl)

void panel_clr(RECT, int);
void cpanel_deselect(FBLK *);

int panel_enter_subdir(panel *, const fblk *, const char *__saved);
int panel_openmsg(panel *, const char *__path);

#endif