/*
 * ZIP.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 *
 *  LZIP - Local file header
 *  CZIP - Central file header
 *  ZCEN - End of central directory record
 */
#ifndef __INC_ZIP
#define __INC_ZIP

#include <wsub.h>

#define ZIPHEADERID	0x4B50		/* two-byte zip lead-in */

#define ZID_LOCAL	0x04034B50	/* signature local file */
#define ZID_CENTRAL	0x02014B50	/* signature central file */
#define ZID_DIGITAL	0x05054b50      /* digital signature */
#define ZID_ENDSENTR	0x06054b50      /* signature end central */

#define ZM_STORED	0	/* compression methods */
#define ZM_SHRUNK	1
#define ZM_REDUCED1	2
#define ZM_REDUCED2	3
#define ZM_REDUCED3	4
#define ZM_REDUCED4	5
#define ZM_IMPLODED	6
#define ZM_TOKENIZED	7
#define ZM_DEFLATED	8
#define ZM_NUM_METHODS	9	/* index of last method + 1 */

#define zip_initcrc()	zip_crcval = 0xFFFFFFFFL

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct 	{ /* Local file header */
	DWORD	signature;	/* 0x04034b50 */
	WORD	version;
	WORD	flag;
	WORD	method;
	WORD	time;
	WORD	date;
	DWORD	crc;
	DWORD	csize;
	DWORD	fsize;
	WORD	fnsize;
	WORD	extsize;
/*	[file name (variable size)] */
/*	[extra field (variable size)] */
      } LZIP; /* 30 byte */

typedef struct 	{ /* Central file header */
	DWORD	signature; 	/* 0x02014b50 */
	WORD	version_made;
	WORD	version_need;
	WORD	bitflag;
	WORD	method;
	WORD	time;
	WORD	date;
	DWORD	crc;
	DWORD	csize;
	DWORD	fsize;
	WORD	fnsize;
	WORD	extsize;
	WORD	cmtsize;
	WORD	disk;
	WORD	int_attrib;
	DWORD	ext_attrib;
	DWORD	offset_local;
/*	[file name (variable size)] */
/*	[extra field (variable size)] */
/*	[file comment (variable size)] */
      } CZIP; /* 46 byte */

typedef struct 	{ /* End of central directory record */
	DWORD	signature; 	/* 0x06054b50 */
	WORD	disk_cur;	/* number of this disk */
	WORD	disk_one;	/* number of the start disk */
	WORD	entry_cur;	/* entries on this disk */
	WORD	entry_dir;	/* ..in the central directory */
	DWORD	size_sd;	/* size of central directory */
	DWORD	offset_sd;	/* offset to start c-directory */
	WORD	comment_size;	/* comment length */
/*	[.ZIP file comment (variable size)] */
      }	ZCEN;

extern DWORD	_CType zip_numhuf;
extern WORD	_CType zip_bsize;	/* size of read buffer */
extern WORD	_CType zip_bindex;	/* index in read buffer */
extern BYTE *	_CType zip_inbuf;       /* read buffer */
extern BYTE *	_CType zip_slide;       /* write buffer */
extern DWORD	_CType zip_wrcount;	/* write count */
extern DWORD	_CType zip_crctab[256];	/* CRC table */
extern DWORD	_CType zip_crcval;      /* current CRC value */
extern WORD	_CType zip_attrib;      /* file attribute */
extern LZIP	_CType zip_local;

void _CType wzipupdatecrc(void *, unsigned);
int _CType wunziphandle(int __sh, int __oh);

int _CType wzipdecrypt(void);
int _CType wzipgetbyte(void);
int _CType wzipupdatekeys(int);
int _CType wzipdecryptbyte(void);

#define wzipdecode(c)   wzipupdatekeys(c ^= wzipdecryptbyte())

int _CType wzipseekback(int __h, int __count);
int _CType wzipreadlocal(int, LZIP *, int __seektoend);
int _CType wzipreadcentral(int, CZIP *, int __seektoend);
int _CType wzipwritelocal(int, LZIP *);
int _CType wzipwritecentral(int, CZIP *);
int _CType wzipgetendcentral(WSUB *, ZCEN *);

int _CType wzipread(WSUB *);
int _CType wzipcopy(WSUB *, FBLK *, const char *__dest);

int _CType wzipopenfiles(void);
char * _CType wzipmkpath(char *);
int _CType wzipcopycentral(int __zh, int __oh, CZIP *);
int _CType wzipcopylocal(int __zh, int __oh, LZIP *);
int _CType wzipffindlocal(long __size);
int _CType wzipadd(long __size, int __date, int __time, char __attrib);


#ifdef __cplusplus
 }
#endif
#endif