include	clib.inc
include	dir.inc
include	io.inc
include	iost.inc
include	string.inc
include	errno.inc
include	conio.inc
include	tinfo.inc
include	version.inc
include mouse.inc

	public	main
	public	_stklen
	public	configpath
	public	searchstring
	public	replacestring
	public	teflag
	public	fsflag
	public	telsize
	public	tepages

	extrn	_argc:word
	extrn	_argv:dword
	extrn	configfile:byte

_DATA	SEGMENT

_stklen	dw 	3000h

cp_info	label byte
	db	'Text Edit Version ',VERS?,' Copyright (c) 2012 Hjort Nidudsson',13,10
size_info = $ - offset cp_info

cp_usage label byte
	db	'Syntax is: TE [-options] <file>',13,10
	db	13,10
	db	'  -q',9,9,	'quiet - no logo',13,10
	db	'  -l<line>',9,	'Line number',13,10
size_usage = $ - offset cp_usage

cp_ini label byte
incbin	<tedit/default.ini>
size_ini = $ - offset cp_ini

te_cfg		db 'te.cfg',0
te_ini		db 'te.ini',0
option_q	db 0
arg_file	dd 0
arg_line	dw 0
configpath	db WMAXPATH dup(0)

searchstring	db 128 dup(0)
replacestring	db 128 dup(?)
fsflag 		db 0
teflag 		dw _T_TEDEFAULT
telsize 	dw 256
tepages 	dw 64
size_config	= $ - offset searchstring


_DATA	ENDS

_TEXT	SEGMENT

main	proc
	.if _argc == 1
	print_usage:
	    mov cx,size_info
	    mov dx,offset cp_info
	    call stderrmsg
	    mov cx,size_usage
	    mov dx,offset cp_usage
	    call stderrmsg
	    xor ax,ax
	    ret
	.endif
	mov bx,word ptr _argv
	invoke strcpy, addr configpath, [bx]
	invoke strfn, dx::ax
	mov bx,ax
	mov byte ptr [bx-1],0
	invoke strfcat, addr configfile, addr configpath, addr te_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_RDONLY, A_OPEN) != -1
	    push ax
	    invoke osread, ax, addr searchstring, size_config
	    call close
	.endif
	mov si,1
    arg_loop:
	cmp si,_argc
	jae init_info
	les bx,_argv
	mov ax,si
	inc si
	shl ax,2
	add bx,ax
	les bx,es:[bx]
	mov ax,es:[bx]
	cmp al,'?'
	je print_usage
	cmp al,'/'
	je options
	cmp al,'-'
	je options
	mov word ptr arg_file,bx
	mov word ptr arg_file+2,es
	jmp arg_loop
    options:
	mov al,ah
	or al,20h
	.if al == 'q'
	    inc option_q
	.elseif al == 'l'
	    add bx,2
	    invoke strtol, es::bx
	    mov arg_line,ax
	.else
	    jmp print_usage
	.endif
	jmp arg_loop
    init_info:
	.if !option_q
	    mov cx,size_info
	    mov dx,offset cp_info
	    call stderrmsg
	.endif
	.if func(access, arg_file, 0)
	    invoke strcpy, addr cp_info, arg_file
	    call eropen
	    xor ax,ax
	    ret
	.endif
      ifdef __MOUSE__
	call mouseinit
	call mouseon
      endif
	invoke strfcat, addr configfile, addr configpath, addr te_ini
	.if func(access, dx::ax, 0)
	    .if func(osopen, addr configfile, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
		push ax
		mov bx,ax
		or _osfile[bx],FH_TEXT
		invoke write,ax,addr cp_ini,size_ini
		call close
	    .endif
	.endif
	invoke tedit, arg_file, arg_line
      ifdef __MOUSE__
	call mouseoff
      endif
	invoke strfcat, addr configfile, addr configpath, addr te_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
	    push ax
	    invoke oswrite, ax, addr searchstring, size_config
	    call close
	.endif
	xor ax,ax
	ret
main	endp

_TEXT	ENDS

	END
