include	clib.inc
ifdef __ZIP__
include	dos.inc
include	iost.inc
include	wsub.inc
include	fblk.inc
include	string.inc
include	unzip.inc
include	confirm.inc
include	progress.inc
include	errno.inc

	extrn	zip_copyendcentral:NEAR
	extrn	arc_flength:DWORD
	extrn	foreslash:byte
	extrn	cp_ziptemp:byte

PPROC	wzipdel, wsub:DWORD, fblk:DWORD ; = SI:DI, CX = flag
	push	si
	push	di
	test	ax,ax		; set if repeated call with same directory
	jnz	wzipdel_repeat
	push	si
	mov	ax,di
	add	ax,fb_name
	push	ax
	test	cl,_A_SUBDIR
	jz	wzipdel_file
	call	confirm_delete_sub
	jmp	wzipdel_01
    wzipdel_repeat:
	push	ds
	push	OFFSET entryname
	jmp	wzipdel_progress
    wzipdel_file:
	push	cx
	call	confirm_delete_file
    wzipdel_01:
	test	ax,ax
	jz	wzipdel_end
	inc	ax
	jz	wzipdel_cancel
	push	ds
	push	WORD PTR wsub
	push	si
	push	di
	call	zip_maketemp
	jz      wzipdel_err
	push	ds
	push	OFFSET __outpath
    wzipdel_progress:
	push	ds
	push	OFFSET __srcfile
	push	WORD PTR arc_flength+2
	push	WORD PTR arc_flength
	call	progress_set
	push	si
	push	di
	call	zip_delete
	mov	es,si
	mov	dl,es:[di]
	and	dl,_A_SUBDIR
	jnz	wzipdel_end
	cmp	ax,1
	je	wzipdel_err
    wzipdel_end:		; return  0: Jump/Ok/Continue
	pop	di      	; 1: Error (-1)
	pop	si      	; 2: ZIP file deleted (Ok)
	ret
    wzipdel_err:
	mov	dx,ds
	mov	ax,OFFSET __outpath
	cmp	errno,0
	jne	wzipdel_errno
	mov	errno,ENOENT
    wzipdel_errno:
	call	erdelete
	inc	ax
    wzipdel_cancel:
	inc	ax
	jmp	wzipdel_end
PEND	wzipdel

_TEXT	SEGMENT

zip_delete PROC PASCAL, fblk:DWORD
	push	si
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	wscopy_open
	cmp	ax,-1
	je	delete_end
	les	si,fblk
	mov	si,es:[si]
	mov	STDO.ios_flag,IO_UPDTOTAL or IO_USEUPD
	test	ax,ax
	jnz	delete_02
    delete_error:
	mov	ax,OSTDI
	call	oclose
	mov	ax,offset __outfile
	call	wscopy_remove
	mov	ax,1
    delete_end:
	pop	si
	ret
    delete_02:			;-------- Local directory
	xor	ax,ax			; match file/*.* if direcetory
	test	si,_A_SUBDIR
	jnz	delete_subdir
	inc	ax			; exact match if file
    delete_subdir:
	push	ax
	call	zip_copylocal		; copy compressed data to temp file
	inc	ax
	jz	delete_error
	dec	ax   			; local offset in DX:CX if found
	jnz	delete_found_local	; local extra field length in BX
	test	si,_A_SUBDIR
	jz	delete_error		; delete sudir ?
    delete_found_local:
	push	dx		;-------- Central directory
	push	cx			; offset local if found
	call	otell
	lodso	zip_endcent.ze_off_cent,cx,bx
	stom	zip_endcent.ze_off_cent
	sub	bx,ax
	sbb	cx,dx
	push	cx
	push	bx
	xor	ax,ax
	test	si,_A_SUBDIR
	jnz	delete_copycentral
	inc	ax
    delete_copycentral:
	push	ax
	call	zip_copycentral
	dec	ax
	jnz	delete_fail		; must be found..
	xor	si,si      	;-------- End Central Directory
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	jnz	delete_not_last_entry
	mov	si,2			; return 2 if last entry deleted
    delete_not_last_entry:
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	zip_copyendcentral
	inc	ax
	mov	ax,si
	jz	delete_fail
	jmp	delete_end
    delete_fail:
	jmp	delete_error
zip_delete ENDP

zip_maketemp PROC PASCAL, wsub:DWORD, fblk:DWORD
	mov	bx,WORD PTR wsub
	push	ds
	push	OFFSET __srcfile
	push	ds
	push	WORD PTR [bx].ws_path
	push	ds
	push	WORD PTR [bx].ws_file
	call	strfcat
	push	dx
	push	ax
	push	dx
	push	OFFSET __outfile
	push	dx
	push	ax
	call	strcpy
	mov	dx,OFFSET cp_ziptemp
	call	addext
	push	dx
	push	ax
	push	dx
	push	OFFSET __outpath
	push	dx
	mov	bx,WORD PTR wsub
	push	WORD PTR [bx].ws_arch
	push	WORD PTR fblk+2
	mov	ax,WORD PTR fblk
	add	ax,fb_name
	push	ax
	call	strfcat
	push	dx
	push	ax
	call	dostounix
	les	bx,fblk
	test	BYTE PTR es:[bx],_A_SUBDIR
	jz      maketemp_01
	push	dx
	push	ax
	push	dx
	push	OFFSET foreslash
	call	strcat
    maketemp_01:
	call	strcmp
	test	ax,ax
	ret
zip_maketemp ENDP

_TEXT	ENDS
endif
	END
