include clib.inc

ifdef __ZIP__

include dos.inc
include io.inc
include iost.inc
include dir.inc
include errno.inc
include string.inc
include wsub.inc
include unzip.inc
include time.inc
include fblk.inc
include	confirm.inc
include syserrls.inc
include doserrls.inc
include conio.inc
include	progress.inc

	.186

USE_DEFLATE = 1

	extrn	cp_ziptemp:byte
	extrn	arc_flength:dword
	extrn	cp_emarchive:byte
	extrn	copy_fast:byte
  if USE_DEFLATE
	_C_BEST		= 0300h
	_C_FASTEST	= 0200h
	_C_SMALLEST	= 0100h
	extrn	file_method:byte
	extrn	compressflag:word
	extrn	compresslevel:byte
  endif

;	public	display_error
	public	zip_copyendcentral

_TEXT	SEGMENT

display_error PROC
	test	STDO.ios_flag,IO_ERROR
	jnz	error_erdisk
	cmp	errno,ENOMEM
	je	error_nomem
	mov	dx,offset CP_DOSER04
	mov	ax,offset cp_emarchive
    error_ermsgt:
	call	@ermsgt
	ret
    error_nomem:
	mov	ax,offset CP_ENOMEM
	call	@ermsg
	ret
    error_erdisk:
	mov	dx,offset CP_ENOMEM
	mov	ax,offset CP_DOSER20
	jmp	error_ermsgt
display_error ENDP

zip_renametemp PROC
	mov	ax,OSTDI
	call	oclose
	mov	ax,OSTDO
	call	oclose
	push	ds
	push	di
	call	filexist
	dec	ax
	jnz	renametemp_fail
	push	ds
	push	si
	call	remove
	push	ds
	push	di
	push	ds
	push	si
	call	rename		; 0 or -1
    renametemp_end:
	ret
    renametemp_fail:
	mov	ax,-1
	jmp	renametemp_end
zip_renametemp ENDP

zip_copyendcentral PROC
	push	si
	push	di
	mov	si,ax
	mov	di,dx
	call	otell
	sub	ax,zip_endcent.ze_off_cent_ax
	sbb	dx,zip_endcent.ze_off_cent_dx
	mov	zip_endcent.ze_size_cent_ax,ax
	mov	zip_endcent.ze_size_cent_dx,dx
	mov	ax,size S_ZEND
	call	oread
	jz	copyendcentral_fail
	push	es
	push	bx
	push	ds
	push	offset zip_endcent
	push	size S_ZEND
	call	memcpy
	mov	ax,zip_endcent.ze_comment_size
	add	ax,size S_ZEND
	push	cx
	push	ax
	call	ocopy
	jz	copyendcentral_fail
	call	oflush
	jz	copyendcentral_fail
	mov	ax,STDO.ios_total_ax
	mov	word ptr arc_flength,ax
	mov	ax,STDO.ios_total_dx
	mov	word ptr arc_flength+2,ax
	call	zip_renametemp		; 0 or -1
    copyendcentral_end:
	pop	di
	pop	si
	ret
    copyendcentral_fail:
	dec	ax			; -1
	jmp	copyendcentral_end
zip_copyendcentral ENDP

update_local PROC
	cmpmm   zip_central.cz_off_local_ax,STDO.ios_total_ax
	jae	update_local_memory
	call	oflush
	jz	update_local_eof
	push	STDO.ios_file
	push	zip_central.cz_off_local_dx
	push	zip_central.cz_off_local_ax
	push	SEEK_SET
	call	lseek
	push	STDO.ios_file
	push	ds
	push	offset zip_local
	push	size S_LZIP
	call	oswrite
	push	STDO.ios_file
	push	0
	push	0
	push	SEEK_END
	call	lseek
    update_local_eof:
	ret
    update_local_memory:
	sub	ax,STDO.ios_total_ax
	sbb	dx,STDO.ios_total_dx
	assert	dx,0,je,"wzipadd"
	push	STDO.ios_bp_dx
	add	ax,STDO.ios_bp_ax
	push	ax
	push	ds
	push	offset zip_local
	push	size S_LZIP
	call	memcpy
	ret
update_local ENDP

mkarchivetmp PROC
	push	ss
	push	ax
	push	ds
	push	offset __outfile
	call	strcpy
	mov	dx,offset cp_ziptemp
	call	addext
	ret
mkarchivetmp ENDP

set_progress PROC
	push	ds
	push	offset __outfile
	push	ss
	push	bx
	push	dx
	push	ax
	call	progress_set
	mov	STDO.ios_flag,IO_USEUPD or IO_UPDTOTAL
	ret
set_progress ENDP

initentry PROC
	push	ss			; AX	offset file name buffer
	push	ax			; BX	time
	mov	ax,bx			; DI	date
	mov	zip_local.lz_time,ax	; CX:DX	size
	mov	zip_central.cz_time,ax	; SI	attrib
	mov	ax,di
	mov	zip_local.lz_date,ax
	mov	zip_central.cz_date,ax
	mov	ax,cx
	mov	zip_local.lz_fsize_dx,ax
	mov	zip_local.lz_csize_dx,ax
	mov	zip_central.cz_fsize_dx,ax
	mov	zip_central.cz_csize_dx,ax
	mov	ax,dx
	mov	zip_local.lz_fsize_ax,ax
	mov	zip_local.lz_csize_ax,ax
	mov	zip_central.cz_fsize_ax,ax
	mov	zip_central.cz_csize_ax,ax
	mov	ax,si
	and	ax,_A_FATTRIB
	mov	zip_central.cz_ext_attrib,ax
	push	ds
	push	offset __outpath
	call	strcpy
	test	si,_A_SUBDIR
	jnz	initentry_len
	push	dx
	push	ax
	call	unixtodos
	push	dx
	push	ax
	xor	ax,ax
	push	ax
	push	ax
	push	dx
	push	offset __srcfile
	call	strfn
	push	dx
	push	ax
	call	strfcat
	push	dx
	push	ax
	call	dostounix
    initentry_len:
	push	dx
	push	ax
	call	strlen
	mov	zip_local.lz_fnsize,ax
	mov	zip_central.cz_fnsize,ax
	ret
initentry ENDP

clearentry PROC
	push	ds
	push	offset zip_local
	push	size S_LZIP
	call	memzero
	push	ds
	push	offset zip_central
	push	size S_CZIP
	call	memzero
	mov	zip_local.lz_pkzip,ZIPHEADERID
	mov	zip_local.lz_zipid,ZIPLOCALID
	mov	byte ptr zip_local.lz_version,20
	mov	zip_central.cz_pkzip,ZIPHEADERID
	mov	zip_central.cz_zipid,ZIPCENTRALID
	mov	byte ptr zip_central.cz_version_made,20
	mov	byte ptr zip_central.cz_version_need,10
	ret
clearentry ENDP

compress PROC
  if USE_DEFLATE
	xor	dx,dx
	mov	dl,compresslevel
	mov	ax,compressflag
	and	ax,_C_BEST
	cmp	ax,_C_BEST
	je	compress_do
	mov	dl,9
	cmp	ax,_C_FASTEST
	jne	compress_do
	mov	dl,1
    compress_do:
	or	dx,dx
	jz	compress_copy
	push	dx
    if not (ISIZE eq 8000h)
	mov	STDI.ios_size,8000h
    endif
	call	zip_deflate
    if not (ISIZE eq 8000h)
	mov	STDI.ios_size,ISIZE
    endif
	ret
    compress_copy:
  endif
	push	zip_local.lz_fsize_dx
	push	zip_local.lz_fsize_ax
	call	ocopy
    compress_end:
	ret
compress ENDP

initcrc	PROC
  if USE_DEFLATE
	xor	ax,ax
	mov	al,file_method
	mov	zip_local.lz_method,ax
	mov	zip_central.cz_method,ax
  endif
	mov	ax,STDI.ios_bb_ax
	not	ax
	mov	zip_local.lz_crc_ax,ax
	mov	zip_central.cz_crc_ax,ax
	mov	ax,STDI.ios_bb_dx
	not	ax
	mov	zip_local.lz_crc_dx,ax
	mov	zip_central.cz_crc_dx,ax
	mov	ax,OSTDI
	call	oclose
	ret
initcrc	ENDP

popstdi	PROC
	push	ds
	push	OSTDI
	push	ss
	push	si
	push	size S_IOST
	call	memcpy
	xor	ax,ax
	ret
popstdi	ENDP

_TEXT	ENDS

PPROC	wzipopen
local	arch[WMAXPATH]:byte
	push	si
	push	di
	call	clearentry
	mov	si,offset entryname
	push	ds
	push	si
	push	ds
	push	offset __outfile
	call	strcpy
	lea	ax,arch
	mov	di,ax
	call	mkarchivetmp
	push	ds
	push	si
	call	strfn
	push	dx
	push	ax
	push	ds
	push	offset centtmp
	call	strcpy
	mov	ax,offset __outfile
	mov	dx,di
	call	wscopy_open
	inc	ax		; (-1) -> (0)
	jz	wzipopen_end	; error
	dec	ax		; (1) --> (0)
	jnz	wzipopen_openc	; cancel
    wzipopen_end:
	or	ax,ax
	pop	di
	pop	si
	ret
    wzipopen_ioerror:
	push    centhnd
	call	close
	push	ds
	push	si
	call	remove
    wzipopen_eropen:
	mov	ax,di
	call	wscopy_remove
	xor	ax,ax
	jmp	wzipopen_end
    wzipopen_openc:
	push	ds
	push	si
	call	ogetouth
	mov	centhnd,ax
	dec	ax
	jz	wzipopen_eropen
	lea	bx,arch
	lodm	arc_flength
	call	set_progress
	push    zip_endcent.ze_off_cent_dx
	push    zip_endcent.ze_off_cent_ax
	call	ocopy
	jz	wzipopen_ioerror
	call	oflush
	jz	wzipopen_ioerror
    wzipopen_lzero:
	push	STDO.ios_file
	mov	ax,centhnd
	mov	STDO.ios_file,ax
	push    zip_endcent.ze_size_cent_dx
	push    zip_endcent.ze_size_cent_ax
	call	ocopy
	jz	wzipopen_errcpy
	call	oflush
	jz	wzipopen_errcpy
	pop	ax
	mov	STDO.ios_file,ax
	mov	ax,zip_endcent.ze_size_cent_ax
	mov	dx,zip_endcent.ze_size_cent_dx
	sub	STDO.ios_total_ax,ax
	sbb	STDO.ios_total_dx,dx
    wzipopen_zero:
	mov	STDO.ios_flag,0
	mov	ax,OSTDI
	call	oclose
	mov	ax,1
	jmp	wzipopen_end
    wzipopen_errcpy:
	pop	ax
	mov	STDO.ios_file,ax
	jmp	wzipopen_ioerror
PEND	wzipopen

PPROC	wzipclose
local	arch[WMAXPATH]:byte
	push	si
	push	di
	mov	si,ax		; result
	lea	ax,arch
	mov	di,ax
	call	mkarchivetmp
	or	si,si
	jnz	wzipclose_remove
	mov	bx,centhnd
	mov	ax,4200h + SEEK_CUR
	xor	cx,cx
	mov	dx,cx
	int	21h
	jc	wzipclose_remove
	mov	zip_endcent.ze_size_cent_ax,ax
	mov	zip_endcent.ze_size_cent_dx,dx
	lea	bx,arch
	call	set_progress
	push	centhnd
	call	close
	mov	STDI.ios_size,8000h
	push	ds
	push	offset entryname
	push	M_RDONLY
	call	oopen
	inc	ax
	jz	wzipclose_remove
	push	zip_endcent.ze_size_cent_dx
	push	zip_endcent.ze_size_cent_ax
	call	ocopy
	or	ax,ax
	jz	wzipclose_close
	push	ds
	pop	es
	mov	cx,size S_ZEND
	mov	bx,offset zip_endcent
	call	owrite
	jz	wzipclose_close
	mov	si,zip_endcent.ze_comment_size
	or	si,si
	jnz	wzipclose_comment
    wzipclose_rename:
	call	oflush
	jz	wzipclose_close
	mov	si,offset __outfile
	call	zip_renametemp
	inc	ax
	jz	wzipclose_remove
    wzipclose_remcent:
	push	ds
	push	offset entryname
	call	remove
    wzipclose_end:
	pop	di
	pop	si
	ret
    wzipclose_remove:
	push	centhnd
	call	close
    wzipclose_remout:
	mov	ax,di
	call	wscopy_remove
	call	display_error
	jmp	wzipclose_remcent
    wzipclose_close:
	mov	ax,OSTDI
	call	oclose
	jmp	wzipclose_remout
    wzipclose_comment:
	push	STDI.ios_file
	call	close
	push	ds
	push	offset __outfile
	push	M_RDONLY
	push	A_OPEN
	call	openfile
	mov	STDI.ios_file,ax
	mov	bx,ax
	inc	ax
	jz	wzipclose_close
	mov	ax,4200h + SEEK_END
	xor	cx,cx
	mov	dx,cx
	sub	dx,si
	sbb	cx,0
	int	21h
	jc	wzipclose_close
	xor	ax,ax
	push	ax
	push	si
	mov	STDI.ios_c,ax
	mov	STDI.ios_i,ax
	call	ocopy
	jz	wzipclose_close
	jmp	wzipclose_rename
PEND	wzipclose

PPROC	wzipadd, fsize:dword, fdate:word, ftime:word, fattrib:word
local	ios:S_IOST
local	ztemp[WMAXPATH]:byte
local	zpath[WMAXPATH]:byte
local	copyl_ax:word
local	copyl_cx:word
local	copyl_dx:word
local	local_size_ax:word
local	local_size_dx:word
local	deflate_begin_ax:word
local	deflate_begin_dx:word
	push	si
	push	di
	mov	di,fdate
	mov	si,fattrib
	xor	ax,ax
  if USE_DEFLATE
	mov	file_method,al
  endif
	cmp	copy_fast,al
	jne	wzipadd_fast
	jmp	wzipadd_slow
    wzipadd_fast:
	lea	ax,zpath
	mov	bx,ftime
	mov	dx,word ptr fsize
	mov	cx,word ptr fsize+2
	call	initentry
	xor	ax,ax
	mov	zip_local.lz_crc_ax,ax
	mov	zip_local.lz_crc_dx,ax
	mov	zip_central.cz_crc_ax,ax
	mov	zip_central.cz_crc_dx,ax
	mov	zip_central.cz_off_local_ax,ax
	mov	zip_central.cz_off_local_dx,ax
	test	si,_A_SUBDIR
	jz	wzipfast_deflate
	jmp	wzipfast_noadd
    wzipfast_deflate:
  if USE_DEFLATE
	dec	ax
	mov	STDI.ios_size,ax
  endif
	call	otell
	mov	zip_central.cz_off_local_ax,ax
	mov	zip_central.cz_off_local_dx,dx
	push	ds
	push	offset __srcfile
	push	M_RDONLY
	call	oopen
  if USE_DEFLATE
	mov	STDI.ios_size,ISIZE
  endif
	inc	ax
	jnz	wzipfast_local
    wzipfast_error:
	mov	ax,OSTDO
	call	oclose
	push	centhnd
	call	close
	push	ds
	push	offset entryname
	call	remove
	mov	ax,-1
	jmp	wzipfast_end
    wzipfast_ercopy:
	mov	ax,OSTDI
	call	oclose
	jmp	wzipfast_error
    wzipfast_local:
	push	ds
	pop	es
	mov	bx,offset zip_local
	mov	cx,size S_LZIP
	call	owrite
	jz	wzipfast_ercopy
	lea	bx,zpath
	mov	cx,zip_local.lz_fnsize
	call	owrite
	jz	wzipfast_ercopy
	mov	STDI.ios_flag,IO_USECRC or IO_USEUPD or IO_UPDTOTAL
	call	otell
	mov	deflate_begin_ax,ax
	mov	deflate_begin_dx,dx
	mov	ax,zip_local.lz_fsize_ax
	or	ax,zip_local.lz_fsize_dx
	jz	wzipfast_zerofile
	call	compress
	or	ax,ax
	jz	wzipfast_ercopy
    wzipfast_zerofile:
	call	initcrc
    wzipfast_noadd:
	call	otell
	mov	zip_endcent.ze_off_cent_ax,ax
	mov	zip_endcent.ze_off_cent_dx,dx
	test	byte ptr fattrib,_A_SUBDIR
	jnz	wzipfast_central
	sub	ax,deflate_begin_ax
	sbb	dx,deflate_begin_dx
	mov	zip_local.lz_csize_ax,ax
	mov	zip_local.lz_csize_dx,dx
	mov	zip_central.cz_csize_ax,ax
	mov	zip_central.cz_csize_dx,dx
	call	update_local
    wzipfast_central:
	push	centhnd
	push	ds
	push	offset zip_central
	push	size S_CZIP
	call	oswrite
	cmp	ax,size S_CZIP
	jne	wzipfast_error
	push	centhnd
	push	ss
	lea	ax,zpath
	push	ax
	push	zip_central.cz_fnsize
	call	oswrite
	cmp	ax,zip_central.cz_fnsize
	jne	wzipfast_error
	inc	zip_endcent.ze_entry_cur
	inc	zip_endcent.ze_entry_dir
	xor	ax,ax
    wzipfast_end:
	or	ax,ax
	pop	di
	pop	si
	ret
    wzipadd_slow:
	movmmax	progress_size,arc_flength
	call	clearentry
	lea	ax,zpath
	push	ss
	push	ax
	push	ds
	push	offset __outpath
	call	strcpy
	mov	ax,offset __outpath
	mov	bx,ftime
	mov	dx,word ptr fsize
	mov	cx,word ptr fsize+2
	call	initentry
	lea	ax,ztemp
	call	mkarchivetmp
	mov	dx,ax
	mov	ax,offset __outfile
	call	wscopy_open
	cmp	ax,-1
	je	wzipfast_end
	mov	STDO.ios_flag,IO_USEUPD or IO_UPDTOTAL
	or	ax,ax
	jnz	wzipadd_copyl
	inc	ax
	jmp	wzipfast_end
    wzipadd_copyl:
	xor	ax,ax
	mov	local_size_ax,ax
	mov	local_size_dx,ax
	inc	ax
	push	ax
	call	zip_copylocal
	mov	copyl_ax,ax	; result: 1 found, 0 not found, -1 error
	mov	copyl_cx,cx	; [cx:dx] offset local directory if found
	mov	copyl_dx,dx
	mov	cx,ax
	inc	ax
	jz	wzipadd_error
	test	si,_A_SUBDIR
	jnz	wzipadd_00
	call	otell
	mov	zip_central.cz_off_local_ax,ax
	mov	zip_central.cz_off_local_dx,dx
    wzipadd_00:
	dec	cx
	jnz	wzipadd_01
	mov	bx,zip_endcent.ze_off_cent_ax
	mov	cx,zip_endcent.ze_off_cent_dx
	sub	bx,ax
	sbb	cx,dx
	mov	local_size_ax,bx
	mov	local_size_dx,cx
	test	si,_A_SUBDIR
	jz	wzipadd_01	; error ?
    wzipadd_skip:
	mov	ax,OSTDI
	call	oclose
	lea	ax,ztemp
	call	wscopy_remove
	jmp	wzipadd_ok
    wzipadd_error:
	mov	di,ax
	mov	ax,OSTDI
	call	oclose
	lea	ax,ztemp
	call	wscopy_remove
	mov	ax,di
	inc	di
	jz      wzipfast_end
	call	display_error
	dec	ax
	jmp	wzipfast_end
    wzipadd_01:
	test	si,_A_SUBDIR
	jnz	wzipadd_noadd
	lea	si,ios
	push	ss
	push	si
	push	ds
	push	OSTDI
	push	size S_IOST
	call	memcpy
  if USE_DEFLATE
	xor	ax,ax
	mov	file_method,al
	dec	ax
	mov	STDI.ios_size,ax
  endif
	push	dx
	push	offset __srcfile
	push	M_RDONLY
	call	oopen
  if USE_DEFLATE
	mov	STDI.ios_size,ISIZE
  endif
	inc	ax
	jnz	wzipadd_wrl
	call	popstdi
	dec	ax
	jmp	wzipadd_error
    wzipadd_wrl:
	push	ds
	pop	es
	mov	bx,offset zip_local
	mov	cx,size S_LZIP
	call	owrite
	jz	wzipadd_ersource
	mov	bx,offset __outpath
	mov	cx,zip_local.lz_fnsize
	call	owrite
	jz	wzipadd_ersource
	mov	STDI.ios_flag,IO_USECRC or IO_USEUPD or IO_UPDTOTAL
	and	STDO.ios_flag,not IO_USEUPD
	call	otell
	mov	deflate_begin_ax,ax
	mov	deflate_begin_dx,dx
	push	ds
	push	offset __srcfile
	push	ds
	push	offset __outfile
	push	word ptr fsize+2
	push	word ptr fsize
	call	progress_set
	jnz	wzipadd_ersource
	mov	ax,zip_local.lz_fsize_ax
	or	ax,zip_local.lz_fsize_dx
	jz	wzipadd_zerofile
	call	compress
	or	ax,ax
	jnz	wzipadd_zerofile
    wzipadd_ersource:
	mov	ax,OSTDI
	call	oclose
	call	popstdi
	jmp	wzipadd_error
    wzipadd_zerofile:
	call	initcrc
	call	popstdi
	lea	bx,ztemp
	lodm	arc_flength
	call	set_progress
    wzipadd_noadd:
	call	otell
	mov	zip_endcent.ze_off_cent_ax,ax
	mov	zip_endcent.ze_off_cent_dx,dx
	test	byte ptr fattrib,_A_SUBDIR
	jnz	wzipadd_copycentral
	sub	ax,deflate_begin_ax
	sbb	dx,deflate_begin_dx
	mov	zip_local.lz_csize_ax,ax
	mov	zip_local.lz_csize_dx,dx
	mov	zip_central.cz_csize_ax,ax
	mov	zip_central.cz_csize_dx,dx
	add	word ptr progress_size,ax
	adc	word ptr progress_size+2,dx
	call	update_local
    wzipadd_copycentral:
	push	copyl_dx
	push	copyl_cx
	push	local_size_dx
	push	local_size_ax
	push	1
	call	zip_copycentral		; offset, size, exact_match
	inc	ax
	jz	wzipadd_ioerror
	dec	ax
	jnz	wzipadd_found
	cmp	ax,copyl_ax		; found local, not central == error
	je	wzipadd_writecentral
    wzipadd_ioerror:
	xor	ax,ax
	jmp	wzipadd_error
    wzipadd_found:
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	push	ds			; file or directory deleted
	push	offset __outpath	; --> ask user to overwrite
	push	zip_central.cz_ext_attrib
	call	confirm_delete_file
	inc	ax
	jz	wzipadd_ioerror		; Cancel
	dec	ax
	jnz	wzipadd_writecentral
	jmp	wzipadd_skip
    wzipadd_writecentral:
	push	ds
	pop	es
	mov	bx,offset zip_central
	mov	cx,size S_CZIP
	call	owrite
	jz	wzipadd_ioerror
	mov	bx,offset __outpath
	mov	cx,zip_central.cz_fnsize
	call	owrite
	jz	wzipadd_ioerror
	inc	zip_endcent.ze_entry_cur
	inc	zip_endcent.ze_entry_dir
	mov	ax,offset __outfile
	lea	dx,ztemp
	call	zip_copyendcentral
	inc	ax
	jz	wzipadd_ioerror
    wzipadd_ok:
	lea	ax,zpath
	push	ds
	push	offset __outpath
	push	ss
	push	ax
	call	strcpy
	xor	ax,ax
	jmp	wzipfast_end
PEND	wzipadd

_DATA	SEGMENT
centtmp	db	'centtmp.$$$',0
centhnd	dw	-1
_DATA	ENDS

endif

	END
