include doszip.inc
include string.inc
include stdio.inc
include	conio.inc
include	keyb.inc
include dir.inc
include io.inc
include iost.inc
include errno.inc
include	tview.inc

	.186

	public	opencfg
	public	getinifile
	public	configread
	public	configwrite
	public	doskey_save
	public	dzcmd_delete
	public	history_init
	public	history_save
	public	history_write

	public	cmhistory	; Alt-F8    - Select command
	public	cmpathleft      ; Alt-Left  - Previous Directory
	public	cmpathright	; Alt-Right - Next Directory
	public	cmdoskey_up	; Alt-Up    - Previous Command
	public	cmdoskey_dn	; Alt-Down  - Next Command
	public	cmsavesetup	; Shift-F10

	public	mklist
	public	format_lst
	public	filelist_bat
	public	findfilemask
	public	cp_selectmask

  ifdef USE_MEMCONFIG
	extrn	memcfg:dword
  endif
	extrn	IDD_DZHISTOR:WORD
	extrn	IDD_DZSSETUP:WORD

S_DZPATH	STRUC
dzp_directory	db MAXPATH dup(?)
dzp_flag	dw ?
dzp_bufid	dw ?
dzp_celid	dw ?
S_DZPATH	ENDS

HISTORY_MAX	= 16
DOSKEY_SIZE	= HISTORY_MAX * 128
HISTORY_SIZE	= HISTORY_MAX * SIZE S_DZPATH
if USE_TVCLASS
DLGTEXT_SIZE	= 2*128+80+80+32+SIZE S_MKLST+TCLSIZE
else
DLGTEXT_SIZE	= 2*128+80+80+32+SIZE S_MKLST
endif
DZCMD_SIZE	= DOSKEY_SIZE + HISTORY_SIZE + DLGTEXT_SIZE

_DATA	SEGMENT

; Configuration file: DZ.CFG

config		dw	DZVERSION
cflag		dw	70A0h
		db	0FFh
console		dw	337Fh
fsflag		db	IO_SEARCHSUB
tvflag		db	_TV_HEXOFFSET
compressflag	dw	_C_ZCREATEZIP or _C_ZBEST
compresslevel	db	6
		db	0
		dw	0,0,0,0
path_a		dw	_W_SORTTYPE+_W_HIDDEN+_W_MINISTATUS+_W_VISIBLE
		db	'*.*',0
		db	28 dup(0)
		db 	WMAXPATH dup(0)
		db 	WMAXPATH dup(0)
		db 	WMAXPATH dup(0)
path_b		dw 	_W_SORTTYPE+_W_HIDDEN+_W_PANELID+_W_MINISTATUS+_W_VISIBLE
		db	'*.*',0
		db 	28 dup(0)
		db 	WMAXPATH dup(0)
		db 	WMAXPATH dup(0)
		db 	WMAXPATH dup(0)
		dw 	-1,0,0,0,0,0,0
		db	'*.*',0
		db	252 dup(0)
at_background	db 	00h,10h,70h,70h,40h,30h,30h,70h
at_foreground	db 	00h,0Ah,0Fh,0Bh,0Fh,07h,07h,07h
		db 	08h,07h,00h,00h,0Fh,0Ah,0Fh,0Fh
at_palett	db 	0,1,2,3,4,5,20,7
		db 	56,57,58,59,60,61,62,63
		db 	WMAXPATH dup(0)

; -- End DZ.CFG --

extini	label	word
	db	'ini',0
extcfg	label	word
	db	'cfg',0
extcmd	label	word
	db	'cmd',0

doskey_bindex db 0
doskey_isnext db 0

; History file: DZ.CMD

history		db HISTORY_SIZE dup(?)
searchstring	db 0
		db 127 dup(0)
findfilemask    db '*.*',0
		db 124 dup(0)
filelist_bat	db 'filelist.bat',0
		db 80-12 dup(?)
format_lst	db '%f\n',0
		db 80-5 dup(?)
mklist		S_MKLST	<0,0,0,0,0,0,0,-1,0,0>
cp_selectmask	db 32 dup(0)

if USE_TVCLASS

	public	tv_class
	public	tv_clversion
	public	tv_classsize
	public	tv_classrow

tv_clversion	dw CLVERSION
tv_classsize	dw CLCOUNT
tv_classrow	dw CLCOUNT
tv_class	S_CLASS CLCOUNT dup(<'byte',1,CLTYPE_BYTE,CLFORM_HEX>)

endif

_DATA	ENDS

_DZIP	SEGMENT

make_dz_cfg PROC
	mov	ax,extcfg
	mov	dx,extcfg+2
make_dz_cfg ENDP

make_dz_ext PROC
	mov	bx,configextp
	mov	[bx],ax
	mov	[bx+2],dx
	mov	dx,ds
	mov	ax,offset configfile
	ret
make_dz_ext ENDP

make_dz_cmd PROC
	mov	ax,extcmd
	mov	dx,extcmd+2
	jmp	make_dz_ext
make_dz_cmd ENDP

getinifile PROC
	mov	ax,extini
	mov	dx,extini+2
	call	make_dz_ext
	ret
getinifile ENDP

doskey_to_command PROC
	push	ds
	push	offset com_base
	push	ds
	mov	ah,doskey_bindex
	mov	al,00h
	shr	ax,1
	add	ax,offset _bufin
	push	ax
	call	strcpy
	ret
doskey_to_command ENDP

setdzpath PROC
	push	si
	push	di
	mov	si,offset history
	xor	ax,ax
	cmp	al,[si]
	jz	setdzpath_end
	mov	di,cpanel
	mov	di,[di]
	mov	dx,[di]
	test	dx,_W_ARCHIVE
	jnz	setdzpath_end
	mov	ax,dx
	and	ax,_W_PANELID or _W_VISIBLE
	or	ax,[si.dzp_flag]
	mov	[di],ax
	mov	ax,[si.dzp_bufid]
	mov	dx,[si.dzp_celid]
	mov	bx,cpanel
	mov	[bx.pn_fcb_index],ax
	mov	[bx.pn_cel_index],dx
	mov	dx,ds
	mov	ax,si
	call	cpanel_setpath
	mov	ax,cpanel
	call	panel_redraw
	mov	ax,1
    setdzpath_end:
	or	ax,ax
	pop	di
	pop	si
	ret
setdzpath ENDP

DZCMD_WRITE PROC
	mov	ax,OPENCMD_WRITE
	mov	dx,1
	jmp	DZCMD_IO
DZCMD_WRITE ENDP

DZCMD_READ PROC
	mov	ax,OPENCMD_READ
	xor	dx,dx
DZCMD_READ ENDP

DZCMD_IO PROC		; int dzcmd_io(int fmode, int (*proc));
	push	dx      ; DX = OSREAD/OSWRITE
	push	ax	; AX = fmode (Read/Write)
	call	opencfg
	pop	dx
	cmp	ax,-1
	je	dzcmdio_01
	push	ax
	push	ax
	push	ds
	push	offset _bufin
	push	DZCMD_SIZE
	or	dx,dx
	jnz	dzcmdio_02
	call	osread
	jmp     dzcmdio_03
    dzcmdio_02:
	call	oswrite
    dzcmdio_03:
	pop	dx
	push	ax
	push	dx
	call	close
	pop	dx
	xor	ax,ax
	cmp	dx,DZCMD_SIZE
	jne	dzcmdio_01
	inc	ax
    dzcmdio_end:
	ret
    dzcmdio_01:
	xor	ax,ax
	jmp	dzcmdio_end
DZCMD_IO ENDP

opencfg	PROC	; flag:WORD
	push	bp
	mov	bp,sp
	mov	bx,offset extini
	mov	ax,[bp+4]
	shr	ax,10
	add	bx,ax
	mov	ax,[bx]
	mov	dx,[bx+2]
	call	make_dz_ext
	push	dx
	push	ax
	mov	ax,[bp+4]
	mov	al,ah
	and	ax,000Fh
	push	ax
	mov	ax,[bp+4]
	xor	ah,ah
	xor	dx,dx
	cmp	ax,1
	jz	opencfg_00
	inc	dx
    opencfg_00:
	push	dx
	push	ax
	call	osopen
	mov	cx,ax
	mov	ax,extini
	mov	dx,extini+2
	mov	bx,configextp
	mov	[bx],ax
	mov	[bx+2],dx
	mov	ax,cx
	cmp	ax,-1
	pop	bp
	ret	2
opencfg ENDP

configread PROC
	push	si
  ifdef USE_MEMCONFIG
	les	bx,memcfg
	or	bx,bx
	jz	configread_M1
	mov	ax,es:[bx.mc_memconfig]
	or	ax,ax
	jz	configread_M1
	mov	ax,es:[bx.mc_flagb]
	mov	path_b,ax
	mov	dx,bx
	add	dx,mc_path
	add	bx,mc_lflag
	push	ds
	push	offset cflag
	push	es
	push	bx
	push	20
	push	ds
	mov	ax,offset path_a+2
	mov	bx,es:[bx]
	and	bx,_W_PANELID
	jnz	configread_M0
	add	ax,size S_PATH
    configread_M0:
	push	ax
	push	es
	push	dx
	push	size S_PATH-2
	call	memcpy
	call	memcpy
	jmp	configread_00
    configread_M1:
  endif
	push	OPENCFG_READ
	call	opencfg
	mov	si,ax
	cmp	ax,-1
	jne	configread_02
    configread_00:
	xor	ax,ax
    configread_end:
	pop	si
	ret
    configread_02:
	push	si
	push	ds
	push	offset config
	push	2
	call	osread
	cmp	ax,2
	jne	configread_03
	mov	ax,config
	mov	config,DZVERSION
	cmp	ax,DZVERSION
	ja	configread_03
	cmp	ax,MINVERSION
	jae	configread_04
    configread_03:
	push	si
	call	close
	jmp	configread_00
    configread_04:
	push	si
	push	ds
	push	offset config+2
	push	size S_CONFIG-2
	call	osread
	push	ax
	push	si
	call	close
	pop	ax
	cmp	ax,size S_CONFIG-2
	mov	ax,1
	je	configread_end
	jmp	configread_00
configread ENDP

configwrite PROC
  ifdef USE_MEMCONFIG
	les	bx,memcfg
	or	bx,bx
	jz	configwrite_04
	mov	ax,path_b
	mov	es:[bx.mc_flagb],ax
	mov	ax,bx
	add	ax,mc_path
	add	bx,mc_lflag
	push	es
	push	bx
	push	ds
	push	offset cflag
	push	20
	push	es
	push	ax
	push	ds
	mov	ax,offset path_a+2
	mov	bx,cpanel
	cmp	bx,panela
	jne	configwrite_03
	add	ax,size S_PATH
    configwrite_03:
	push	ax
	push	size S_PATH-2
	call	memcpy
	call	memcpy
    configwrite_04:
  endif
	push	OPENCFG_WRITE
	call	opencfg
	cmp	ax,-1
	je	configwrite_00
	push	ax
	push	ax
	push	ds
	push	offset config
	push	size S_CONFIG
	call	oswrite
	pop	dx
	push	ax
	push	dx
	call	close
	pop	ax
	cmp	ax,size S_CONFIG
	jne	configwrite_00
	or	ax,ax
	jmp	configwrite_01
    configwrite_00:
	xor	ax,ax
  ifdef USE_MEMCONFIG
	les	bx,memcfg
	or	bx,bx
	jz	configwrite_01
	inc	ax
	mov	es:[bx.mc_memconfig],ax
	dec	ax
  endif
    configwrite_01:
	ret
configwrite ENDP

dzcmd_delete PROC
	call	make_dz_cmd
	push	dx
	push	ax
	push	dx
	push	ax
	push	0
	call	setfattr
	call	remove
	ret
dzcmd_delete ENDP

history_init PROC
	call	DZCMD_READ
	jz	history_init_00
	push	ds
	push	offset history
	push	ds
	push	offset _bufin+DOSKEY_SIZE
	push	HISTORY_SIZE+DLGTEXT_SIZE
	call	memcpy
    history_init_00:
	ret
history_init ENDP

history_save PROC
	mov	bx,cpanel
	mov	bx,[bx]
	mov	ax,[bx]
	and	ax,_W_ARCHIVE
	jz      history_save_00
	xor	ax,ax
	jmp	history_save_02
    history_save_00:
	push	si
	mov	si,offset _bufin
	xor	ax,ax
	push	ds
	push	si
	push	ax
	call	fullpath
	or	ax,ax
	jz	history_save_01
	push	ds
	push	si
	push	ds
	mov	si,offset history
	push	si
	call	strcmp
	or	ax,ax
	jz	history_save_01
	xor	ax,ax
	call	history_move
	push	ds
	push	si
	push	ds
	push	offset _bufin
	call	strcpy
	mov	bx,cpanel
	mov	ax,[bx.pn_fcb_index]
	mov	[si.dzp_bufid],ax
	mov	ax,[bx.pn_cel_index]
	mov	[si.dzp_celid],ax
	mov	bx,[bx]
	mov	ax,[bx]
	and	ax,not (_W_PANELID or _W_VISIBLE)
	mov	[si.dzp_flag],ax
	inc	ax
    history_save_01:
	pop	si
    history_save_02:
	ret
history_save ENDP

history_write PROC
	call	DZCMD_READ
	jnz	history_write_00
	push	ds
	push	offset _bufin
	push	DZCMD_SIZE
	call	memzero
    history_write_00:
	push	ds
	push	offset _bufin + DOSKEY_SIZE
	push	ds
	push	offset history
	push	HISTORY_SIZE+DLGTEXT_SIZE
	call	memcpy
	call	DZCMD_WRITE
	ret
history_write ENDP

doskey_save PROC
	push	ds
	push	offset com_base
	call	strtrim
	or	ax,ax
	jz	doskey_save_03
    doskey_save_00:
	push	si
	mov	si,offset _bufin
	call	DZCMD_READ
	jnz	doskey_save_01
	push	ds
	push	si
	push	DZCMD_SIZE
	call	memzero
    doskey_save_01:
	push	ds
	push	offset com_base
	push	ds
	push	si
	call	strcmp
	or	ax,ax
	jz	doskey_save_02
	push	ds
	mov	ax,si
	add	ax,128
	push	ax
	push	ds
	push	si
	push	15*128
	call	memmove
	push	ds
	push	si
	push	ds
	push	offset com_base
	call	strcpy
	call	DZCMD_WRITE
    doskey_save_02:
	mov	ax,1
	pop	si
    doskey_save_03:
	ret
doskey_save ENDP

history_move PROC ; void history_move(int direction);
	push	si
	push	di
	mov	di,ds
	mov	es,di
	mov	di,offset convbuf
	mov	si,offset history
	mov	cx,size S_DZPATH
	mov	bx,size S_DZPATH * (HISTORY_MAX-1)
	cld
	or	al,al
	jnz	history_move_00
	add	si,bx
    history_move_00:
	rep	movsb
	mov	cx,bx
	mov	di,offset history
	mov	si,di
	add	si,size S_DZPATH
	or	al,al
	jnz	history_move_01
	xchg	si,di
	dec	bx
	add	si,bx
	add	di,bx
	inc	bx
	std
    history_move_01:
	rep	movsb
	mov	si,offset convbuf
	mov	di,offset history
	mov	cx,size S_DZPATH
	cld
	or	al,al
	jz	history_move_02
	add	di,bx
    history_move_02:
	rep	movsb
	pop	di
	pop	si
	ret
history_move ENDP

;--------------------------------------------------------------------------

cmhistory PROC DIST
	push	si
	push	di
	les	bx,DLG_Commandline
	test	byte ptr es:[bx],_D_ONSCR
	jz	cmhistory_end
	call	DZCMD_READ
	jz	cmhistory_end
	cmp	ah,_bufin
	je	cmhistory_end
	push	ds
	push	IDD_DZHISTOR
	call	rsopen
	jz	cmhistory_end
	push	dx
	push	ax
	push	ds
	push	IDD_DZHISTOR
	push	dx
	push	ax
	push	dx
	push	ax
	push	dx
	push	ax
	push	dx
	push	ax
	mov	di,offset _bufin
	add	bx,16
	push	ds
	mov	si,ds
	mov	es,si
	mov	ds,dx
	mov	dx,not _O_STATE
	xor	cx,cx
    cmhistory_init:
	mov	[bx.to_data_ax],di
	mov	[bx.to_data_dx],si
	cmp	byte ptr es:[di],0
	jz	cmhistory_event
	and	[bx],dx
	add	bx,size S_TOBJ
	add	di,128
	inc	cx
	cmp	cx,16
	jb	cmhistory_init
	jmp	cmhistory_event
    cmhistory_end:
	pop	di
	pop	si
	ret
    cmhistory_event:
	pop	ds
	pop	bx
	pop	es
	mov	ax,cx
	mov	es:[bx.dl_count],al
	mov	al,doskey_bindex
	mov	es:[bx.dl_index],al
	cmp	al,cl
	jb	cmhistory_02
	mov	es:[bx.dl_index],ch
    cmhistory_02:
	call	twshow
	call	tdinit
	call	rsevent
	call	twclose
	xor	ax,ax
	or	dx,dx
	jz	cmhistory_end
	mov	al,es:[bx.dl_index]
	mov	doskey_bindex,al
	mov	ax,dx
	shl	ax,4
	add	bx,ax
	push	ds
	push	offset com_base
	pushm	es:[bx.to_data_ax]
	call	strcpy
	push	KEY_END
	call	comevent
	mov	ax,1
	jmp	cmhistory_end
cmhistory ENDP

cmpathleft PROC DIST	; Alt-Left - Previous Directory
	call	history_save
	mov	ax,1
	call	history_move
	call	SETDZPATH
	jz	cmpathleft_00
	ret
    cmpathleft_00:
	call	history_move
	ret
cmpathleft ENDP

cmpathright PROC DIST	; Alt-Right - Next Directory
	call	history_save
	xor	ax,ax
	call	history_move
	call	SETDZPATH
	jz	cmpathright_00
	ret
    cmpathright_00:
	inc	ax
	call	history_move
	ret
cmpathright ENDP

cmdoskey_up PROC DIST
	les	bx,DLG_Commandline
	test	byte ptr es:[bx],_D_ONSCR
	jz	cmdoskey_up_end
	call	DZCMD_READ
	jz	cmdoskey_up_end
	cmp	doskey_isnext,al
	jne	cmdoskey_up_00
	mov	com_base,ah
	jmp	cmdoskey_up_01
    cmdoskey_up_00:
	call	doskey_to_command
	inc	doskey_bindex
	cmp	doskey_bindex,16
	jb	cmdoskey_up_01
	mov	doskey_bindex,0
    cmdoskey_up_01:
	push	KEY_END
	call	comevent
	mov	ax,1
	mov	doskey_isnext,ah
    cmdoskey_up_end:
	ret
cmdoskey_up ENDP

cmdoskey_dn PROC DIST
	les	bx,DLG_Commandline
	test	byte ptr es:[bx],_D_ONSCR
	jz	cmdoskey_dn_end
	call	DZCMD_READ
	jz	cmdoskey_dn_end
	cmp	doskey_isnext,ah
	jne	cmdoskey_dn_00
	mov	com_base,ah
	jmp	cmdoskey_dn_03
    cmdoskey_dn_00:
	cmp	doskey_bindex,0
	jne	cmdoskey_dn_01
	mov	doskey_bindex,15
	jmp	cmdoskey_dn_02
    cmdoskey_dn_01:
	dec	doskey_bindex
    cmdoskey_dn_02:
	call	doskey_to_command
    cmdoskey_dn_03:
	push	KEY_END
	call	comevent
	mov	ax,1
	mov	doskey_isnext,al
    cmdoskey_dn_end:
	ret
cmdoskey_dn ENDP

cmsavesetup PROC DIST
	push	ds
	push	IDD_DZSSETUP
	call	rsmodal
	or	ax,ax
	jz	savesetup_00
	call	configwrite
	jz	savesetup_01
	mov	ax,1
    savesetup_00:
	ret
    savesetup_01:
	call	make_dz_cfg
	call	eropen
	inc	ax
	jmp	savesetup_00
cmsavesetup ENDP

_DZIP	ENDS

	END
