include	clib.inc
include	iost.inc
include	string.inc
include	conio.inc

	.186

	public	continuesearch
	public	notfoundmsg
	extrn	IDD_IDSEARCH:WORD
	extrn	searchstring: byte

_DATA	SEGMENT

cp_search	db 'Search',0
cp_notfoundmsg	db "Search string not found: '%s'",0
cp_stlsearch	db 'Search for the string:',0

hexstring	db 128 dup(?)
hexstrlen	dw 0

_DATA	ENDS

_TEXT	SEGMENT

ioseek PROC	; Init search offset
	mov	ax,STDI.ios_bb_ax	; current offset
	mov	dx,STDI.ios_bb_dx
	mov	cx,STDI.ios_flag
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	test	cx,IO_SEARCHSET
	jz	ioseek_inc
	xor	ax,ax
	cwd
    ioseek_set:
	mov	di,ax
	mov	bp,dx
	push	dx
	push	ax
	push	SEEK_SET
	call	oseek
	ret
    ioseek_inc:
	test	cx,IO_SEARCHCUR
	jnz	ioseek_set
	add	ax,1			; offset++ (continue)
	adc	dx,0
	jmp	ioseek_set
ioseek ENDP

cbwcase PROC
	mov	ah,al
	test	STDI.ios_flag,IO_SEARCHCASE
	jnz	cbwcase_end
	cmp	al,'Z'
	ja	cbwcase_upr
	cmp	al,'A'
	jb	cbwcase_upr
	add	al,'a'-'A'
    cbwcase_upr:
	cmp	ah,'z'
	ja	cbwcase_end
	cmp	ah,'a'
	jb	cbwcase_end
	sub	ah,'a'-'A'
    cbwcase_end:
	ret
cbwcase	ENDP

seekbx PROC
	cmp	bx,STDI.ios_i
	ja	seekbx_slow
	sub	di,bx
	sbb	bp,0
	sub	STDI.ios_i,bx
	ret
    seekbx_slow:
	push	si
	mov	si,bx
    seekbx_loop:
	call	oungetc
	sub	di,1
	sbb	bp,0
	dec	si
	jnz	seekbx_loop
	pop	si
	ret
seekbx ENDP

findc PROC
	mov	dx,ax
    findc_get:
	call	ogetc
	jz	findc_eof
	add	di,1
	adc	bp,0
	cmp	al,dl
	je	findc_found
	cmp	al,dh
	jne	findc_get
    findc_found:
	or	ah,1
    findc_eof:
	ret
findc ENDP

lodhex PROC
	mov	al,[si]
	or	al,al
	jz	lodhex_end
	inc	si
	cmp	al,'0'
	jb	lodhex
	cmp	al,'9'
	jbe	lodhex_ok
	or	al,20h
	cmp	al,'f'
	ja	lodhex
	sub	al,27h
    lodhex_ok:
	sub	al,'0'
	or	si,si
    lodhex_end:
	ret
lodhex ENDP

searchfound PROC
	mov	ax,si
	sub	ax,dx
	inc	ax
	sub	di,ax
	sbb	bp,0
	mov	ax,di
	mov	dx,bp
	or	di,1
	ret
searchfound ENDP

searchhex PROC
	push	bp
	push	si
	push	di
	call	ioseek
	jz	searchhex_end
	xor	cx,cx
	mov	si,offset searchstring
	mov	bx,offset hexstring
    searchhex_xtol:
	call	lodhex
	jz	searchhex_hexl
	mov	ah,al
	call	lodhex
	jnz	searchhex_mkb
	xchg	al,ah
    searchhex_mkb:
	shl	ah,4
	or	al,ah
	mov	[bx],al
	inc	bx
	inc	cx
	jmp	searchhex_xtol
    searchhex_found:
	call	searchfound
    searchhex_end:
	pop	di
	pop	si
	pop	bp
	ret
    searchhex_hexl:
	mov	hexstrlen,cx
    searchhex_scan:
	mov	al,hexstring
	mov	ah,al
	call	findc
	jz	searchhex_end
	mov	si,offset hexstring
    searchhex_cmp:
	call	ogetc
	jz	searchhex_end
	add	di,1
	adc	bp,0
	inc	si
	mov	dx,offset hexstring
	mov	cx,si
	sub	cx,dx
	cmp	cx,hexstrlen
	je	searchhex_found
	cmp	al,[si]
	je	searchhex_cmp
	mov	bx,si
	sub	bx,dx
	call	seekbx
	jmp	searchhex_scan
searchhex ENDP

search	PROC
	xor	ax,ax
	cmp	searchstring,al
	je	search_end
	test	STDI.ios_flag,IO_SEARCHHEX
	jz	searchtxt
	jmp	searchhex
    search_end:
	ret
search	ENDP

searchtxt PROC
	push	bp
	push	si
	push	di
	call	ioseek
	jz	searchtxt_end
	jmp	searchtxt_scan
    searchtxt_found:
	call	searchfound
    searchtxt_end:
	pop	di
	pop	si
	pop	bp
	ret
    searchtxt_scan:
	mov	al,searchstring
	call	cbwcase
	call	findc
	jz	searchtxt_end
	mov	si,offset searchstring
    searchtxt_cmp:
	call	ogetc
	jz	searchtxt_end
	add	di,1
	adc	bp,0
	inc	si
	mov	dx,offset searchstring
	mov	cl,al
	mov	al,[si]
	or	al,al
	jz	searchtxt_found
	call	cbwcase
	cmp	ah,cl
	je	searchtxt_cmp
	cmp	al,cl
	je	searchtxt_cmp
	mov	bx,si
	sub	bx,dx
	call	seekbx
	jmp	searchtxt_scan
searchtxt ENDP

event_tedit PROC DIST
	mov	tminascii,1
	call	tdteditevent
	mov	tminascii,' '
	ret
event_tedit ENDP

notfoundmsg PROC
	mov	cp_notfoundmsg+24,' '
	push	ds
	push	offset searchstring
	call	strlen
	cmp	ax,29
	jb	notfoundmsg_00
	mov	cp_notfoundmsg+24,10
    notfoundmsg_00:
	push	ds
	push	offset searchstring
	mov	dx,offset cp_notfoundmsg
	mov	ax,offset cp_search
	call	@stdmsg
	add	sp,4
	ret
notfoundmsg ENDP

continuesearch PROC DIST
	push	bp
	sub	sp,160
	mov	bp,sp
	xor	ax,ax
	cmp	searchstring,al
	jz	continuesearch_end
	push	ss
	push	bp
	push	ds
	push	offset cp_stlsearch
	call	wcpushst
	mov	bh,_scrrow
	mov	bl,24
	mov	cx,80-24
	mov	dx,ds
	mov	ax,offset searchstring
	call	@scputs
	push	STDI.ios_bb_dx
	push	STDI.ios_bb_ax
	push	SEEK_SET
	call	oseekl
	or	ax,ax
	jz	continuesearch_notfound
	test	STDI.ios_flag,IO_SEARCHHEX
	jz	continuesearch_txt
	call	searchhex
	jmp	continuesearch_set
    continuesearch_txt:
	call	searchtxt
    continuesearch_set:
	jz	continuesearch_notfound
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	mov	ax,1
    continuesearch_pop:
	push	ax
	push	ss
	push	bp
	call	wcpopst
	pop	ax
    continuesearch_end:
	add	sp,160
	pop	bp
	ret
    continuesearch_notfound:
	call	notfoundmsg
	xor	ax,ax
	jmp	continuesearch_pop
continuesearch ENDP

_TEXT	ENDS

PPROC	osearch, h:word, fsize:dword, buf:dword, bsize:word, flag:word
	mov	bx,h
	mov	STDI.ios_file,bx
	mov	ax,4201h
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	osearch_err
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	xor	ax,ax
	mov	STDI.ios_c,ax
	mov	STDI.ios_i,ax
	mov	ax,bsize
	mov	STDI.ios_size,ax
	mov	ax,word ptr buf
	mov	STDI.ios_bp_ax,ax
	mov	ax,word ptr buf+2
	mov	STDI.ios_bp_dx,ax
	mov	ax,flag
	or	ax,IO_SEARCHCUR
	mov	STDI.ios_flag,ax
	call	search
	mov	STDI.ios_size,ISIZE
	jnz	osearch_end
    osearch_err:
	mov	ax,-1
	cwd
    osearch_end:
	ret
PEND	osearch

PPROC	cmsearchidd, sflag:word
	push	ds
	push	IDD_IDSEARCH
	call	rsopen
	jz	cmsearchidd_nul
	push	dx
	push	ax
	push	ds
	push	IDD_IDSEARCH
	push	dx
	push	ax
	push	dx
	push	ax
	mov	es:[bx+1*16].to_count,128 shr 4
	mov	word ptr es:[bx+1*16].to_data_ax,offset searchstring
	mov	word ptr es:[bx+1*16].to_data_dx,ds
	mov	word ptr es:[bx+1*16].to_proc_ax,offset event_tedit
	LMOV	word ptr es:[bx+1*16].to_proc_dx,cs
	mov	ax,sflag
	mov	dl,_O_FLAGB
	test	ax,IO_SEARCHCASE
	jz	cmsearchidd_hex?
	or	es:[bx+2*16],dl
    cmsearchidd_hex?:
	test	ax,IO_SEARCHHEX
	jz	cmsearchidd_cur?
	or	es:[bx+3*16],dl
    cmsearchidd_cur?:
	mov	dl,_O_RADIO
	test	ax,IO_SEARCHCUR
	jz	cmsearchidd_rset
	or	es:[bx+6*16],dl
	jmp	cmsearchidd_event
    cmsearchidd_nul:
	xor	ax,ax
	jmp	cmsearchidd_end
    cmsearchidd_rset:
	or	es:[bx+7*16],dl
    cmsearchidd_event:
	call	tdinit
	call	rsevent
	call	twclose
	or	dx,dx
	jz	cmsearchidd_nul
	mov	ax,sflag
	and	ax,not IO_SEARCHMASK
	mov	dl,_O_FLAGB
	test	es:[bx+2*16],dl
	jz	cmsearchidd_hex
	or	ax,IO_SEARCHCASE
    cmsearchidd_hex:
	test	es:[bx+3*16],dl
	jz	cmsearchidd_cur
	or	ax,IO_SEARCHHEX
    cmsearchidd_cur:
	test	byte ptr es:[bx+6*16],_O_RADIO
	jz	cmsearchidd_set
	or	ax,IO_SEARCHCUR
	jmp	cmsearchidd_toend
    cmsearchidd_set:
	or	ax,IO_SEARCHSET
    cmsearchidd_toend:
	mov	dx,ax
	xor	ax,ax
	cmp	searchstring,al
	je	cmsearchidd_end
	inc	ax
    cmsearchidd_end:
	ret
PEND	cmsearchidd

PPROC	cmdsearch, offs:dword
	xor	ax,ax
	cmp	ax,word ptr offs+2
	jne	cmdsearch_00
	cmp	word ptr offs,16
	jb	cmdsearch_end
    cmdsearch_00:
	push	STDI.ios_flag
	call	cmsearchidd
	jz	cmdsearch_end
	mov	STDI.ios_flag,dx
	and	dx,IO_SEARCHCUR or IO_SEARCHSET
	push	dx
	call	continuesearch
	pop	dx
	or	STDI.ios_flag,dx
    cmdsearch_end:
	ret
PEND	cmdsearch

	END
